/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection;

import java.lang.reflect.Method;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.Introspector;
import org.carrot2.util.preprocessor.shaded.apache.velocity.util.introspection.SecureIntrospectorControl;
import org.slf4j.Logger;

public class SecureIntrospectorImpl
extends Introspector
implements SecureIntrospectorControl {
    private String[] badClasses;
    private String[] badPackages;

    public SecureIntrospectorImpl(String[] stringArray, String[] stringArray2, Logger logger) {
        super(logger);
        this.badClasses = stringArray;
        this.badPackages = stringArray2;
    }

    @Override
    public Method getMethod(Class clazz, String string, Object[] objectArray) throws IllegalArgumentException {
        if (!this.checkObjectExecutePermission(clazz, string)) {
            this.log.warn("Cannot retrieve method {} from object of class {} due to security restrictions.", (Object)string, (Object)clazz.getName());
            return null;
        }
        return super.getMethod(clazz, string, objectArray);
    }

    @Override
    public boolean checkObjectExecutePermission(Class clazz, String string) {
        int n;
        if (string != null && (string.equals("wait") || string.equals("notify"))) {
            return false;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (String.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Class.class.isAssignableFrom(clazz) && string != null && string.equals("getName")) {
            return true;
        }
        String string2 = clazz.getName();
        if (string2.startsWith("[L") && string2.endsWith(";")) {
            string2 = string2.substring(2, string2.length() - 1);
        }
        String string3 = (n = string2.lastIndexOf(46)) == -1 ? "" : string2.substring(0, n);
        for (String string4 : this.badPackages) {
            if (!string3.equals(string4)) continue;
            return false;
        }
        for (String string4 : this.badClasses) {
            if (!string2.equals(string4)) continue;
            return false;
        }
        return true;
    }
}

