/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.carrot2.language.DefaultStemmersProvider;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.LexicalData;
import org.carrot2.language.LexicalDataImpl;
import org.carrot2.util.ClassRelativeResourceLookup;
import org.carrot2.util.ResourceLookup;

public class DefaultLexicalDataProvider
implements LanguageComponentsProvider {
    @Override
    public Set<String> languages() {
        return DefaultStemmersProvider.STEMMER_SUPPLIERS.keySet();
    }

    @Override
    public ResourceLookup defaultResourceLookup() {
        return new ClassRelativeResourceLookup(this.getClass());
    }

    @Override
    public Set<Class<?>> componentTypes() {
        return Collections.singleton(LexicalData.class);
    }

    @Override
    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup, Set<Class<?>> componentTypes) throws IOException {
        if (!this.componentTypes().equals(componentTypes)) {
            throw new IllegalArgumentException();
        }
        String langPrefix = language.toLowerCase(Locale.ROOT);
        LexicalDataImpl lexicalData = new LexicalDataImpl(resourceLookup, langPrefix + ".stopwords.utf8", langPrefix + ".stoplabels.utf8");
        return Map.of(LexicalData.class, () -> lexicalData);
    }

    @Override
    public String name() {
        return "Carrot2 Lexical Data (" + String.join((CharSequence)", ", DefaultStemmersProvider.STEMMER_SUPPLIERS.keySet()) + ")";
    }
}

