/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.carrot2.language.LanguageComponentsLoader;

public final class LanguageComponents {
    private final String language;
    private final Map<Class<?>, Supplier<?>> components;

    public LanguageComponents(String language, Map<Class<?>, Supplier<?>> suppliers) {
        this.language = language;
        this.components = suppliers;
    }

    public String language() {
        return this.language;
    }

    public <T> T get(Class<T> componentClass) {
        Supplier<?> supplier = this.components.get(componentClass);
        if (supplier == null) {
            throw new RuntimeException(String.format(Locale.ROOT, "This instance of LanguageComponents for language '%s' does not come with a supplier of component class '%s'.", this.language, componentClass.getName()));
        }
        return componentClass.cast(supplier.get());
    }

    public <T> LanguageComponents override(Class<T> clazz, Supplier<? extends T> supplier) {
        LinkedHashMap clonedSuppliers = new LinkedHashMap(this.components);
        clonedSuppliers.put(clazz, supplier);
        return new LanguageComponents(this.language, clonedSuppliers);
    }

    public Set<Class<?>> components() {
        return this.components.keySet();
    }

    public static LanguageComponentsLoader loader() {
        return new LanguageComponentsLoader();
    }
}

