/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.language;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.LexicalData;
import org.carrot2.language.LexicalDataImpl;
import org.carrot2.util.ClassRelativeResourceLookup;
import org.carrot2.util.ResourceLookup;

public abstract class SingleLanguageComponentsProviderImpl
implements LanguageComponentsProvider {
    private final String language;
    private final String providerName;
    private final LinkedHashMap<Class<?>, SupplierLoader<?>> components = new LinkedHashMap();

    protected SingleLanguageComponentsProviderImpl(String providerName, String language) {
        this.language = language;
        this.providerName = providerName;
    }

    @Override
    public String name() {
        return this.providerName;
    }

    @Override
    public final Set<String> languages() {
        return Collections.singleton(this.language);
    }

    @Override
    public ResourceLookup defaultResourceLookup() {
        return new ClassRelativeResourceLookup(this.getClass());
    }

    @Override
    public Set<Class<?>> componentTypes() {
        return this.components.keySet();
    }

    @Override
    public Map<Class<?>, Supplier<?>> load(String language, ResourceLookup resourceLookup, Set<Class<?>> componentTypes) throws IOException {
        LinkedHashMap result = new LinkedHashMap();
        for (Class<?> componentType : componentTypes) {
            SupplierLoader<?> supplierLoader = this.components.get(componentType);
            if (supplierLoader == null) {
                throw new IllegalArgumentException("Not a registered component: " + componentType);
            }
            result.put(componentType, supplierLoader.get(language, resourceLookup));
        }
        return result;
    }

    protected final <T> void register(Class<T> clazz, SupplierLoader<? extends T> loader) {
        if (this.components.containsKey(clazz)) {
            throw new IllegalArgumentException("Component class already registered: " + clazz);
        }
        this.components.put(clazz, loader);
    }

    protected final <T> void registerResourceless(Class<T> clazz, Supplier<T> supplier) {
        this.register(clazz, (language, resourceLoader) -> supplier);
    }

    protected static LexicalData loadLexicalData(String language, ResourceLookup resourceLookup) throws IOException {
        String langPrefix = language.toLowerCase(Locale.ROOT);
        return new LexicalDataImpl(resourceLookup, langPrefix + ".stopwords.utf8", langPrefix + ".stoplabels.utf8");
    }

    protected static interface SupplierLoader<T> {
        public Supplier<T> get(String var1, ResourceLookup var2) throws IOException;
    }
}

