/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.mahout;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.carrot2.math.mahout.AbstractVector;
import org.carrot2.math.mahout.CardinalityException;
import org.carrot2.math.mahout.IndexException;
import org.carrot2.math.mahout.Vector;
import org.carrot2.math.mahout.VectorView;
import org.carrot2.math.mahout.function.DoubleDoubleFunction;
import org.carrot2.math.mahout.function.PlusMult;

public class DenseVector
extends AbstractVector {
    private double[] values;

    public DenseVector() {
        super(0);
    }

    public DenseVector(double[] values) {
        this(values, false);
    }

    public DenseVector(double[] values, boolean shallowCopy) {
        super(values.length);
        this.values = shallowCopy ? values : (double[])values.clone();
    }

    public DenseVector(DenseVector values, boolean shallowCopy) {
        this(values.values, shallowCopy);
    }

    public DenseVector(int cardinality) {
        super(cardinality);
        this.values = new double[cardinality];
    }

    public DenseVector(Vector vector) {
        super(vector.size());
        this.values = new double[vector.size()];
        Iterator<Vector.Element> it = vector.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            this.values[e.index()] = e.get();
        }
    }

    @Override
    public DenseVector clone() {
        return new DenseVector((double[])this.values.clone());
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double dotSelf() {
        double result = 0.0;
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            double value = this.getQuick(i);
            result += value * value;
        }
        return result;
    }

    @Override
    public double getQuick(int index) {
        return this.values[index];
    }

    @Override
    public DenseVector like() {
        return new DenseVector(this.size());
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values[index] = value;
    }

    @Override
    public Vector assign(double value) {
        this.lengthSquared = -1.0;
        Arrays.fill(this.values, value);
        return this;
    }

    @Override
    public Vector assign(Vector other, DoubleDoubleFunction function) {
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        if (function instanceof PlusMult) {
            Vector.Element e;
            Iterator<Vector.Element> it = other.iterateNonZero();
            while (it.hasNext() && (e = it.next()) != null) {
                this.values[e.index()] = function.apply(this.values[e.index()], e.get());
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.values[i] = function.apply(this.values[i], other.getQuick(i));
            }
        }
        this.lengthSquared = -1.0;
        return this;
    }

    public Vector assign(DenseVector vector) {
        if (vector.values.length != this.values.length) {
            this.values = new double[vector.values.length];
        }
        System.arraycopy(vector.values, 0, this.values, 0, this.values.length);
        return this;
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.length;
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size());
        }
        if (offset + length > this.size()) {
            throw new IndexException(offset + length, this.size());
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DenseVector) {
            return Arrays.equals(this.values, ((DenseVector)o).values);
        }
        return super.equals(o);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        double result = 0.0;
        for (double value : this.values) {
            result += value * value;
        }
        this.lengthSquared = result;
        return result;
    }

    public void addAll(Vector v) {
        if (this.size() != v.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        Iterator<Vector.Element> iter = v.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            int n = element.index();
            this.values[n] = this.values[n] + element.get();
        }
    }

    private final class NonDefaultIterator
    extends AbstractIterator<Vector.Element> {
        private final DenseElement element;
        private int index;

        private NonDefaultIterator() {
            this.element = new DenseElement();
            this.index = 0;
        }

        protected Vector.Element fetch() {
            while (this.index < DenseVector.this.size() && DenseVector.this.values[this.index] == 0.0) {
                ++this.index;
            }
            if (this.index < DenseVector.this.size()) {
                this.element.index = this.index++;
                return this.element;
            }
            return (Vector.Element)this.done();
        }
    }

    private final class AllIterator
    extends AbstractIterator<Vector.Element> {
        private final DenseElement element;

        private AllIterator() {
            this.element = new DenseElement();
            this.element.index = -1;
        }

        protected Vector.Element fetch() {
            if (this.element.index + 1 < DenseVector.this.size()) {
                ++this.element.index;
                return this.element;
            }
            return (Vector.Element)this.done();
        }
    }

    private final class DenseElement
    implements Vector.Element {
        int index;

        private DenseElement() {
        }

        @Override
        public double get() {
            return DenseVector.this.values[this.index];
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            DenseVector.this.lengthSquared = -1.0;
            DenseVector.this.values[this.index] = value;
        }
    }
}

