/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.math.mahout;

import com.carrotsearch.hppc.AbstractIterator;
import java.util.Iterator;
import org.carrot2.math.mahout.AbstractVector;
import org.carrot2.math.mahout.CardinalityException;
import org.carrot2.math.mahout.Vector;
import org.carrot2.math.mahout.list.IntArrayList;
import org.carrot2.math.mahout.map.OpenIntDoubleHashMap;

public class RandomAccessSparseVector
extends AbstractVector {
    private static final int INITIAL_CAPACITY = 11;
    private OpenIntDoubleHashMap values;

    public RandomAccessSparseVector() {
        super(0);
    }

    public RandomAccessSparseVector(int cardinality) {
        this(cardinality, Math.min(cardinality, 11));
    }

    public RandomAccessSparseVector(int cardinality, int initialCapacity) {
        super(cardinality);
        this.values = new OpenIntDoubleHashMap(initialCapacity);
    }

    public RandomAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        Vector.Element e;
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.values.put(e.index(), e.get());
        }
    }

    private RandomAccessSparseVector(int cardinality, OpenIntDoubleHashMap values) {
        super(cardinality);
        this.values = values;
    }

    public RandomAccessSparseVector(RandomAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : (OpenIntDoubleHashMap)other.values.clone();
    }

    @Override
    public RandomAccessSparseVector clone() {
        return new RandomAccessSparseVector(this.size(), (OpenIntDoubleHashMap)this.values.clone());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        Iterator<Vector.Element> it = this.iterateNonZero();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            Vector.Element e = it.next();
            result.append(e.index());
            result.append(':');
            result.append(e.get());
        }
        result.append('}');
        return result.toString();
    }

    @Override
    public Vector assign(Vector other) {
        Vector.Element e;
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        this.values.clear();
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.setQuick(e.index(), e.get());
        }
        return this;
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return false;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        if (value == 0.0) {
            this.values.removeKey(index);
        } else {
            this.values.put(index, value);
        }
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.size();
    }

    @Override
    public RandomAccessSparseVector like() {
        return new RandomAccessSparseVector(this.size(), this.values.size());
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    private final class NonDefaultIterator
    extends AbstractIterator<Vector.Element> {
        private final RandomAccessElement element;
        private final IntArrayList indices;
        private int offset;

        private NonDefaultIterator() {
            this.element = new RandomAccessElement();
            this.indices = new IntArrayList();
            RandomAccessSparseVector.this.values.keys(this.indices);
        }

        protected Vector.Element fetch() {
            if (this.offset >= this.indices.size()) {
                return (Vector.Element)this.done();
            }
            this.element.index = this.indices.get(this.offset);
            ++this.offset;
            return this.element;
        }
    }

    private final class AllIterator
    extends AbstractIterator<Vector.Element> {
        private final RandomAccessElement element;

        private AllIterator() {
            this.element = new RandomAccessElement();
            this.element.index = -1;
        }

        protected Vector.Element fetch() {
            if (this.element.index + 1 < RandomAccessSparseVector.this.size()) {
                ++this.element.index;
                return this.element;
            }
            return (Vector.Element)this.done();
        }
    }

    private final class RandomAccessElement
    implements Vector.Element {
        int index;

        private RandomAccessElement() {
        }

        @Override
        public double get() {
            return RandomAccessSparseVector.this.values.get(this.index);
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void set(double value) {
            RandomAccessSparseVector.this.lengthSquared = -1.0;
            if (value == 0.0) {
                RandomAccessSparseVector.this.values.removeKey(this.index);
            } else {
                RandomAccessSparseVector.this.values.put(this.index, value);
            }
        }
    }
}

