/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.attrs.AttrComposite;
import org.carrot2.attrs.AttrDouble;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.LabelFilter;
import org.carrot2.text.preprocessing.filter.LeftCompleteLabelFilter;
import org.carrot2.text.preprocessing.filter.RightCompleteLabelFilter;

public class CompleteLabelFilter
extends AttrComposite
implements LabelFilter {
    public AttrDouble labelOverrideThreshold;
    private LeftCompleteLabelFilter leftCompleteLabelFilter;
    private RightCompleteLabelFilter rightCompleteLabelFilter;

    public CompleteLabelFilter() {
        this.labelOverrideThreshold = this.attributes.register("labelOverrideThreshold", AttrDouble.builder().label("Truncated label threshold").min(0.0).max(1.0).defaultValue(0.65));
        this.leftCompleteLabelFilter = new LeftCompleteLabelFilter();
        this.rightCompleteLabelFilter = new RightCompleteLabelFilter();
    }

    @Override
    public void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        double labelOverrideThreshold = (Double)this.labelOverrideThreshold.get();
        this.leftCompleteLabelFilter.filter(context, acceptedStems, acceptedPhrases, labelOverrideThreshold);
        this.rightCompleteLabelFilter.filter(context, acceptedStems, acceptedPhrases, labelOverrideThreshold);
    }
}

