/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.attrs.AttrInteger;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;

public class MinLengthLabelFilter
extends SingleLabelFilterBase {
    public AttrInteger minLength;

    public MinLengthLabelFilter() {
        this.minLength = this.attributes.register("minLength", AttrInteger.builder().label("Minimum label length").defaultValue(3));
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        int length;
        int[] wordIndices = context.allPhrases.wordIndices[phraseIndex];
        char[][] wordImage = context.allWords.image;
        int minLength = (Integer)this.minLength.get();
        int wordIndex = 0;
        for (length = wordImage[wordIndices[wordIndex++]].length; length < minLength && wordIndex < wordIndices.length; length += wordImage[wordIndices[wordIndex]].length + 1, ++wordIndex) {
        }
        return length >= minLength;
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        return context.allWords.image[wordIndex].length >= (Integer)this.minLength.get();
    }
}

