/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.carrot2.elasticsearch.ClusteringActionRequest;
import org.carrot2.elasticsearch.ClusteringActionRequestBuilder;
import org.carrot2.elasticsearch.ClusteringActionResponse;
import org.carrot2.elasticsearch.LoggerUtils;
import org.carrot2.elasticsearch.LogicalField;
import org.carrot2.elasticsearch.Preconditions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.search.RestSearchAction;

public class ClusteringAction
extends ActionType<ClusteringActionResponse> {
    public static final String NAME = "indices:data/read/cluster";
    public static final ClusteringAction INSTANCE = new ClusteringAction();

    private ClusteringAction() {
        super(NAME, ClusteringActionResponse::new);
    }

    public Writeable.Reader<ClusteringActionResponse> getResponseReader() {
        return ClusteringActionResponse::new;
    }

    public static class RestClusteringAction
    extends BaseRestHandler {
        protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        public static String NAME = "_search_with_clusters";
        private static final EnumMap<LogicalField, String> GET_REQUEST_FIELDMAPPERS = new EnumMap(LogicalField.class);

        public List<RestHandler.Route> routes() {
            return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/" + NAME), new RestHandler.Route(RestRequest.Method.POST, "/{index}/" + NAME), new RestHandler.Route(RestRequest.Method.POST, "/{index}/{type}/" + NAME), new RestHandler.Route(RestRequest.Method.GET, "/" + NAME), new RestHandler.Route(RestRequest.Method.GET, "/{index}/" + NAME), new RestHandler.Route(RestRequest.Method.GET, "/{index}/{type}/" + NAME));
        }

        public String getName() {
            return NAME;
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
            if (request.method() == RestRequest.Method.POST && !request.hasContent()) {
                return channel -> LoggerUtils.emitErrorResponse(channel, this.logger, new IllegalArgumentException("Request body was expected for a POST request."));
            }
            if (request.method() == RestRequest.Method.GET && request.hasContent()) {
                return channel -> LoggerUtils.emitErrorResponse(channel, this.logger, new IllegalArgumentException("Request body was unexpected for a GET request."));
            }
            ClusteringActionRequestBuilder actionBuilder = new ClusteringActionRequestBuilder((ElasticsearchClient)client);
            SearchRequest searchRequest = new SearchRequest();
            switch (request.method()) {
                case POST: {
                    searchRequest.indices(Strings.splitStringByCommaToArray((String)request.param("index")));
                    searchRequest.types(Strings.splitStringByCommaToArray((String)request.param("type")));
                    actionBuilder.setSearchRequest(searchRequest);
                    actionBuilder.setSource(request.content(), request.getXContentType(), request.getXContentRegistry());
                    break;
                }
                case GET: {
                    RestSearchAction.parseSearchRequest((SearchRequest)searchRequest, (RestRequest)request, null, size -> searchRequest.source().size(size));
                    actionBuilder.setSearchRequest(searchRequest);
                    this.fillFromGetRequest(actionBuilder, request);
                    break;
                }
                default: {
                    throw Preconditions.unreachable();
                }
            }
            HashSet<String> passSecurityHeaders = new HashSet<String>(Arrays.asList("es-security-runas-user", "_xpack_security_authentication"));
            Map<String, String> securityHeaders = client.threadPool().getThreadContext().getHeaders().entrySet().stream().filter(e -> passSecurityHeaders.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return channel -> {
                try (ThreadContext.StoredContext ignored = client.threadPool().getThreadContext().stashContext();){
                    client.threadPool().getThreadContext().copyHeaders(securityHeaders.entrySet());
                    client.execute((ActionType)INSTANCE, (ActionRequest)((ClusteringActionRequest)actionBuilder.request()), (ActionListener)new ActionListener<ClusteringActionResponse>(){

                        public void onResponse(ClusteringActionResponse response) {
                            try {
                                XContentBuilder builder = channel.newBuilder();
                                builder.startObject();
                                response.toXContent(builder, (ToXContent.Params)request);
                                builder.endObject();
                                channel.sendResponse((RestResponse)new BytesRestResponse(response.getSearchResponse().status(), builder));
                            }
                            catch (Exception e) {
                                logger.debug("Failed to emit response.", (Throwable)e);
                                this.onFailure(e);
                            }
                        }

                        public void onFailure(Exception e) {
                            LoggerUtils.emitErrorResponse(channel, logger, e);
                        }
                    });
                }
            };
        }

        private void fillFromGetRequest(ClusteringActionRequestBuilder actionBuilder, RestRequest request) {
            if (request.hasParam(ClusteringActionRequest.JSON_QUERY_HINT)) {
                actionBuilder.setQueryHint(request.param(ClusteringActionRequest.JSON_QUERY_HINT));
            } else {
                actionBuilder.setQueryHint(request.param("q"));
            }
            if (request.hasParam(ClusteringActionRequest.JSON_ALGORITHM)) {
                actionBuilder.setAlgorithm(request.param(ClusteringActionRequest.JSON_ALGORITHM));
            }
            if (request.hasParam(ClusteringActionRequest.JSON_MAX_HITS)) {
                actionBuilder.setMaxHits(request.param(ClusteringActionRequest.JSON_MAX_HITS));
            }
            if (request.hasParam(ClusteringActionRequest.JSON_CREATE_UNGROUPED_CLUSTER)) {
                actionBuilder.setCreateUngroupedDocumentsCluster(Boolean.parseBoolean(request.param(ClusteringActionRequest.JSON_CREATE_UNGROUPED_CLUSTER)));
            }
            if (request.hasParam(ClusteringActionRequest.JSON_LANGUAGE)) {
                actionBuilder.setDefaultLanguage(request.param(ClusteringActionRequest.JSON_LANGUAGE));
            }
            for (Map.Entry<LogicalField, String> e : GET_REQUEST_FIELDMAPPERS.entrySet()) {
                if (!request.hasParam(e.getValue())) continue;
                for (String spec : Strings.splitStringByCommaToArray((String)request.param(e.getValue()))) {
                    actionBuilder.addFieldMappingSpec(spec, e.getKey());
                }
            }
        }

        static {
            for (LogicalField lf : LogicalField.values()) {
                GET_REQUEST_FIELDMAPPERS.put(lf, "field_mapping_" + lf.name().toLowerCase(Locale.ROOT));
            }
        }
    }
}

