/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.carrot2.elasticsearch.ClusteringException;
import org.carrot2.elasticsearch.FieldMappingSpec;
import org.carrot2.elasticsearch.FieldSource;
import org.carrot2.elasticsearch.LogicalField;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class ClusteringActionRequest
extends ActionRequest
implements IndicesRequest.Replaceable {
    public static String JSON_QUERY_HINT = "query_hint";
    public static String JSON_FIELD_MAPPING = "field_mapping";
    public static String JSON_ALGORITHM = "algorithm";
    public static String JSON_ATTRIBUTES = "attributes";
    public static String JSON_SEARCH_REQUEST = "search_request";
    public static String JSON_MAX_HITS = "max_hits";
    public static String JSON_CREATE_UNGROUPED_CLUSTER = "create_ungrouped";
    public static String JSON_LANGUAGE = "language";
    private SearchRequest searchRequest;
    private String queryHint;
    private List<FieldMappingSpec> fieldMapping = new ArrayList<FieldMappingSpec>();
    private String algorithm;
    private int maxHits = Integer.MAX_VALUE;
    private Map<String, Object> attributes;
    boolean createUngroupedDocumentsCluster;
    private String defaultLanguage = "English";

    public ClusteringActionRequest setSearchRequest(SearchRequest searchRequest) {
        this.searchRequest = searchRequest;
        return this;
    }

    public ClusteringActionRequest setSearchRequest(SearchRequestBuilder builder) {
        return this.setSearchRequest((SearchRequest)builder.request());
    }

    ClusteringActionRequest() {
    }

    public ClusteringActionRequest(StreamInput in) throws IOException {
        SearchRequest searchRequest;
        this.searchRequest = searchRequest = new SearchRequest(in);
        this.queryHint = in.readOptionalString();
        this.algorithm = in.readOptionalString();
        this.maxHits = in.readInt();
        this.createUngroupedDocumentsCluster = in.readBoolean();
        this.defaultLanguage = in.readString();
        int count = in.readVInt();
        while (count-- > 0) {
            FieldMappingSpec spec = new FieldMappingSpec(in);
            this.fieldMapping.add(spec);
        }
        boolean hasAttributes = in.readBoolean();
        if (hasAttributes) {
            this.attributes = in.readMap();
        }
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public ClusteringActionRequest setQueryHint(String queryHint) {
        this.queryHint = queryHint;
        return this;
    }

    public String getQueryHint() {
        return this.queryHint;
    }

    public ClusteringActionRequest setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setMaxHits(int maxHits) {
        assert (maxHits >= 0);
        this.maxHits = maxHits;
    }

    public void setMaxHits(String value) {
        if (value == null || value.trim().isEmpty()) {
            this.setMaxHits(Integer.MAX_VALUE);
        } else {
            this.setMaxHits(Integer.parseInt(value));
        }
    }

    public int getMaxHits() {
        return this.maxHits;
    }

    public ClusteringActionRequest setAttributes(Map<String, Object> map) {
        this.attributes = map;
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void source(BytesReference source, XContentType xContentType, NamedXContentRegistry xContentRegistry) {
        if (source == null || source.length() == 0) {
            return;
        }
        try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)source, (XContentType)xContentType);){
            Object maxHits;
            Map searchRequestMap;
            Map attributes;
            String algorithm;
            Map fieldMapping;
            String defaultLanguage;
            String queryHint;
            Map asMap = parser.mapOrdered();
            Boolean createUngrouped = (Boolean)asMap.get(JSON_CREATE_UNGROUPED_CLUSTER);
            if (createUngrouped != null) {
                this.setCreateUngroupedDocumentsCluster(createUngrouped);
            }
            if ((queryHint = (String)asMap.get(JSON_QUERY_HINT)) != null) {
                this.setQueryHint(queryHint);
            }
            if ((defaultLanguage = (String)asMap.get(JSON_LANGUAGE)) != null) {
                this.setDefaultLanguage(defaultLanguage);
            }
            if ((fieldMapping = (Map)asMap.get(JSON_FIELD_MAPPING)) != null) {
                this.parseFieldSpecs(fieldMapping);
            }
            if ((algorithm = (String)asMap.get(JSON_ALGORITHM)) != null) {
                this.setAlgorithm(algorithm);
            }
            if ((attributes = (Map)asMap.get(JSON_ATTRIBUTES)) != null) {
                this.setAttributes(attributes);
            }
            if ((searchRequestMap = (Map)asMap.get(JSON_SEARCH_REQUEST)) != null) {
                if (this.searchRequest == null) {
                    this.searchRequest = new SearchRequest();
                }
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).map(searchRequestMap);
                XContentParser searchXParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, Strings.toString((XContentBuilder)builder));
                SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)searchXParser);
                this.searchRequest.source(searchSourceBuilder);
            }
            if ((maxHits = asMap.get(JSON_MAX_HITS)) != null) {
                this.setMaxHits(maxHits.toString());
            }
        }
        catch (Exception e) {
            String sSource = "_na_";
            try {
                sSource = XContentHelper.convertToJson((BytesReference)source, (boolean)false, (boolean)false, (XContentType)xContentType);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new ClusteringException("Failed to parse source [" + sSource + "]", e, new Object[0]);
        }
    }

    private void parseFieldSpecs(Map<String, List<String>> fieldSpecs) {
        for (Map.Entry<String, List<String>> e : fieldSpecs.entrySet()) {
            LogicalField logicalField = LogicalField.valueOfCaseInsensitive(e.getKey());
            if (logicalField == null) continue;
            for (String fieldSpec : e.getValue()) {
                this.addFieldMappingSpec(fieldSpec, logicalField);
            }
        }
    }

    public ClusteringActionRequest addFieldMapping(String fieldName, LogicalField logicalField) {
        this.fieldMapping.add(new FieldMappingSpec(fieldName, logicalField, FieldSource.FIELD));
        return this;
    }

    public ClusteringActionRequest addSourceFieldMapping(String sourceFieldName, LogicalField logicalField) {
        this.fieldMapping.add(new FieldMappingSpec(sourceFieldName, logicalField, FieldSource.SOURCE));
        return this;
    }

    public ClusteringActionRequest addHighlightedFieldMapping(String fieldName, LogicalField logicalField) {
        this.fieldMapping.add(new FieldMappingSpec(fieldName, logicalField, FieldSource.HIGHLIGHT));
        return this;
    }

    public ClusteringActionRequest addFieldMappingSpec(String fieldSpec, LogicalField logicalField) {
        FieldSource.ParsedFieldSource pfs = FieldSource.parseSpec(fieldSpec);
        if (pfs.source != null) {
            switch (pfs.source) {
                case HIGHLIGHT: {
                    this.addHighlightedFieldMapping(pfs.fieldName, logicalField);
                    break;
                }
                case FIELD: {
                    this.addFieldMapping(pfs.fieldName, logicalField);
                    break;
                }
                case SOURCE: {
                    this.addSourceFieldMapping(pfs.fieldName, logicalField);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        if (pfs.source == null) {
            throw new ElasticsearchException("Field mapping specification must contain a  valid source prefix for the field source: " + fieldSpec, new Object[0]);
        }
        return this;
    }

    List<FieldMappingSpec> getFieldMapping() {
        return this.fieldMapping;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException ex;
        ActionRequestValidationException validationException = null;
        if (this.searchRequest == null) {
            validationException = ValidateActions.addValidationError((String)"No delegate search request", validationException);
        }
        if (this.queryHint == null) {
            validationException = ValidateActions.addValidationError((String)"query hint may be empty but must not be null.", (ActionRequestValidationException)validationException);
        }
        if (this.fieldMapping.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"At least one field should be mapped to a logical document field.", (ActionRequestValidationException)validationException);
        }
        if ((ex = this.searchRequest.validate()) != null) {
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors((Iterable)ex.validationErrors());
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        assert (this.searchRequest != null);
        this.searchRequest.writeTo(out);
        out.writeOptionalString(this.queryHint);
        out.writeOptionalString(this.algorithm);
        out.writeInt(this.maxHits);
        out.writeBoolean(this.createUngroupedDocumentsCluster);
        out.writeString(this.defaultLanguage);
        out.writeVInt(this.fieldMapping.size());
        for (FieldMappingSpec spec : this.fieldMapping) {
            spec.writeTo(out);
        }
        boolean hasAttributes = this.attributes != null;
        out.writeBoolean(hasAttributes);
        if (hasAttributes) {
            out.writeMap(this.attributes);
        }
    }

    public IndicesRequest indices(String ... strings) {
        return this.searchRequest.indices(strings);
    }

    public String[] indices() {
        return this.searchRequest.indices();
    }

    public IndicesOptions indicesOptions() {
        return this.searchRequest.indicesOptions();
    }

    public void setCreateUngroupedDocumentsCluster(boolean enabled) {
        this.createUngroupedDocumentsCluster = enabled;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = Objects.requireNonNull(defaultLanguage);
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }
}

