/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.util.HashMap;
import java.util.Map;
import org.carrot2.elasticsearch.ClusteringAction;
import org.carrot2.elasticsearch.ClusteringActionRequest;
import org.carrot2.elasticsearch.ClusteringActionResponse;
import org.carrot2.elasticsearch.LogicalField;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentType;

public class ClusteringActionRequestBuilder
extends ActionRequestBuilder<ClusteringActionRequest, ClusteringActionResponse> {
    public ClusteringActionRequestBuilder(ElasticsearchClient client) {
        super(client, (ActionType)ClusteringAction.INSTANCE, (ActionRequest)new ClusteringActionRequest());
    }

    public ClusteringActionRequestBuilder setSearchRequest(SearchRequestBuilder builder) {
        ((ClusteringActionRequest)this.request).setSearchRequest(builder);
        return this;
    }

    public ClusteringActionRequestBuilder setSearchRequest(SearchRequest searchRequest) {
        ((ClusteringActionRequest)this.request).setSearchRequest(searchRequest);
        return this;
    }

    public ClusteringActionRequestBuilder setQueryHint(String queryHint) {
        if (queryHint == null) {
            throw new IllegalArgumentException("Query hint may be empty but must not be null.");
        }
        ((ClusteringActionRequest)this.request).setQueryHint(queryHint);
        return this;
    }

    public ClusteringActionRequestBuilder setAlgorithm(String algorithm) {
        ((ClusteringActionRequest)this.request).setAlgorithm(algorithm);
        return this;
    }

    public ClusteringActionRequestBuilder setSource(BytesReference content, XContentType xContentType, NamedXContentRegistry xContentRegistry) {
        ((ClusteringActionRequest)this.request).source(content, xContentType, xContentRegistry);
        return this;
    }

    public ClusteringActionRequestBuilder setMaxHits(int maxHits) {
        ((ClusteringActionRequest)this.request).setMaxHits(maxHits);
        return this;
    }

    public ClusteringActionRequestBuilder setMaxHits(String maxHits) {
        ((ClusteringActionRequest)this.request).setMaxHits(maxHits);
        return this;
    }

    public ClusteringActionRequestBuilder addAttributes(Map<String, Object> attributes) {
        if (((ClusteringActionRequest)this.request).getAttributes() == null) {
            ((ClusteringActionRequest)this.request).setAttributes(new HashMap<String, Object>());
        }
        ((ClusteringActionRequest)this.request).getAttributes().putAll(attributes);
        return this;
    }

    public ClusteringActionRequestBuilder addAttribute(String key, Object value) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put(key, value);
        return this.addAttributes(tmp);
    }

    public ClusteringActionRequestBuilder setAttributes(Map<String, Object> attributes) {
        ((ClusteringActionRequest)this.request).setAttributes(attributes);
        return this;
    }

    public ClusteringActionRequestBuilder addFieldMapping(String fieldName, LogicalField logicalField) {
        ((ClusteringActionRequest)this.request).addFieldMapping(fieldName, logicalField);
        return this;
    }

    public ClusteringActionRequestBuilder addSourceFieldMapping(String fieldName, LogicalField logicalField) {
        ((ClusteringActionRequest)this.request).addSourceFieldMapping(fieldName, logicalField);
        return this;
    }

    public ClusteringActionRequestBuilder addHighlightedFieldMapping(String fieldName, LogicalField logicalField) {
        ((ClusteringActionRequest)this.request).addHighlightedFieldMapping(fieldName, logicalField);
        return this;
    }

    public ClusteringActionRequestBuilder addFieldMappingSpec(String fieldSpec, LogicalField logicalField) {
        ((ClusteringActionRequest)this.request).addFieldMappingSpec(fieldSpec, logicalField);
        return this;
    }

    public ClusteringActionRequestBuilder setCreateUngroupedDocumentsCluster(boolean enabled) {
        ((ClusteringActionRequest)this.request).setCreateUngroupedDocumentsCluster(enabled);
        return this;
    }

    public ClusteringActionRequestBuilder setDefaultLanguage(String language) {
        ((ClusteringActionRequest)this.request).setDefaultLanguage(language);
        return this;
    }
}

