/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.carrot2.elasticsearch.DocumentGroup;
import org.carrot2.elasticsearch.Preconditions;
import org.carrot2.elasticsearch.ToString;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ClusteringActionResponse
extends ActionResponse
implements ToXContent {
    private SearchResponse searchResponse;
    private DocumentGroup[] topGroups;
    private Map<String, String> info;

    ClusteringActionResponse(StreamInput in) throws IOException {
        boolean hasSearchResponse = in.readBoolean();
        if (hasSearchResponse) {
            this.searchResponse = new SearchResponse(in);
        }
        int documentGroupsCount = in.readVInt();
        this.topGroups = new DocumentGroup[documentGroupsCount];
        for (int i = 0; i < documentGroupsCount; ++i) {
            DocumentGroup group;
            this.topGroups[i] = group = new DocumentGroup(in);
        }
        int entries = in.readVInt();
        this.info = new LinkedHashMap<String, String>();
        for (int i = 0; i < entries; ++i) {
            this.info.put(in.readOptionalString(), in.readOptionalString());
        }
    }

    public ClusteringActionResponse(SearchResponse searchResponse, DocumentGroup[] topGroups, Map<String, String> info) {
        this.searchResponse = Preconditions.checkNotNull(searchResponse);
        this.topGroups = Preconditions.checkNotNull(topGroups);
        this.info = Collections.unmodifiableMap(Preconditions.checkNotNull(info));
    }

    public SearchResponse getSearchResponse() {
        return this.searchResponse;
    }

    public DocumentGroup[] getDocumentGroups() {
        return this.topGroups;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.searchResponse != null) {
            this.searchResponse.innerToXContent(builder, ToXContent.EMPTY_PARAMS);
        }
        builder.startArray("clusters");
        if (this.topGroups != null) {
            for (DocumentGroup group : this.topGroups) {
                group.toXContent(builder, params);
            }
        }
        builder.endArray();
        builder.field("info", this.info);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        boolean hasSearchResponse = this.searchResponse != null;
        out.writeBoolean(hasSearchResponse);
        if (hasSearchResponse) {
            this.searchResponse.writeTo(out);
        }
        out.writeVInt(this.topGroups == null ? 0 : this.topGroups.length);
        if (this.topGroups != null) {
            for (DocumentGroup group : this.topGroups) {
                group.writeTo(out);
            }
        }
        out.writeVInt(this.info == null ? 0 : this.info.size());
        if (this.info != null) {
            for (Map.Entry entry : this.info.entrySet()) {
                out.writeOptionalString((String)entry.getKey());
                out.writeOptionalString((String)entry.getValue());
            }
        }
    }

    public String toString() {
        return ToString.objectToJson(this);
    }

    static final class Fields {
        static final String SEARCH_RESPONSE = "search_response";
        static final String CLUSTERS = "clusters";
        static final String INFO = "info";
        static final String _SCROLL_ID = "_scroll_id";
        static final String _SHARDS = "_shards";
        static final String TOTAL = "total";
        static final String SUCCESSFUL = "successful";
        static final String FAILED = "failed";
        static final String FAILURES = "failures";
        static final String STATUS = "status";
        static final String INDEX = "index";
        static final String SHARD = "shard";
        static final String REASON = "reason";
        static final String TOOK = "took";
        static final String TIMED_OUT = "timed_out";

        Fields() {
        }

        static final class Info {
            public static final String ALGORITHM = "algorithm";
            public static final String SEARCH_MILLIS = "search-millis";
            public static final String CLUSTERING_MILLIS = "clustering-millis";
            public static final String TOTAL_MILLIS = "total-millis";
            public static final String INCLUDE_HITS = "include-hits";
            public static final String MAX_HITS = "max-hits";
            public static final String LANGUAGES = "languages";

            Info() {
            }
        }
    }
}

