/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.carrot2.attrs.AcceptingVisitor;
import org.carrot2.attrs.AttrVisitor;
import org.carrot2.attrs.Attrs;
import org.carrot2.clustering.Cluster;
import org.carrot2.clustering.ClusteringAlgorithm;
import org.carrot2.clustering.ClusteringAlgorithmProvider;
import org.carrot2.elasticsearch.ClusteringActionRequest;
import org.carrot2.elasticsearch.ClusteringActionResponse;
import org.carrot2.elasticsearch.ClusteringContext;
import org.carrot2.elasticsearch.DocumentGroup;
import org.carrot2.elasticsearch.FieldMappingSpec;
import org.carrot2.elasticsearch.InputDocument;
import org.carrot2.elasticsearch.OptionalQueryHintSetterVisitor;
import org.carrot2.elasticsearch.Preconditions;
import org.carrot2.language.LanguageComponents;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.profile.SearchProfileShardResults;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ClusteringActionTransport
extends TransportAction<ClusteringActionRequest, ClusteringActionResponse> {
    protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final TransportSearchAction searchAction;
    private final ClusteringContext context;

    @Inject
    public ClusteringActionTransport(TransportService transportService, TransportSearchAction searchAction, ClusteringContext controllerSingleton, ActionFilters actionFilters) {
        super("indices:data/read/cluster", actionFilters, transportService.getTaskManager());
        this.searchAction = searchAction;
        this.context = controllerSingleton;
        transportService.registerRequestHandler("indices:data/read/cluster", "same", ClusteringActionRequest::new, (TransportRequestHandler)new TransportHandler());
    }

    protected void doExecute(Task task, final ClusteringActionRequest clusteringRequest, final ActionListener<ClusteringActionResponse> listener) {
        final long tsSearchStart = System.nanoTime();
        this.searchAction.execute((ActionRequest)clusteringRequest.getSearchRequest(), (ActionListener)new ActionListener<SearchResponse>(){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onResponse(SearchResponse response) {
                String algorithmId;
                long tsSearchEnd = System.nanoTime();
                LinkedHashMap<String, ClusteringAlgorithmProvider> algorithms = ClusteringActionTransport.this.context.getAlgorithms();
                ClusteringAlgorithmProvider provider = algorithms.get(algorithmId = ClusteringActionTransport.requireNonNullElse(clusteringRequest.getAlgorithm(), algorithms.keySet().iterator().next()));
                if (provider == null) {
                    listener.onFailure((Exception)new IllegalArgumentException("No such algorithm: " + algorithmId));
                    return;
                }
                ClusteringAlgorithm algorithm = (ClusteringAlgorithm)provider.get();
                try {
                    String queryHint;
                    Map<String, Object> requestAttrs = clusteringRequest.getAttributes();
                    if (requestAttrs != null) {
                        Attrs.populate((AcceptingVisitor)algorithm, requestAttrs);
                    }
                    if ((queryHint = clusteringRequest.getQueryHint()) != null) {
                        algorithm.accept((AttrVisitor)new OptionalQueryHintSetterVisitor(clusteringRequest.getQueryHint()));
                    }
                    List<InputDocument> documents = ClusteringActionTransport.this.prepareDocumentsForClustering(clusteringRequest, response);
                    String defaultLanguage = clusteringRequest.getDefaultLanguage();
                    if (!ClusteringActionTransport.this.context.isLanguageSupported(defaultLanguage)) {
                        throw new RuntimeException("The requested default language is not supported: '" + defaultLanguage + "'");
                    }
                    Map<String, List<InputDocument>> documentsByLanguage = documents.stream().collect(Collectors.groupingBy(doc -> {
                        String lang = doc.language();
                        return lang == null ? defaultLanguage : lang;
                    }));
                    long tsClusteringTotal = 0L;
                    HashSet<String> warnOnce = new HashSet<String>();
                    LinkedHashMap<String, List> clustersByLanguage = new LinkedHashMap<String, List>();
                    for (Map.Entry<String, List<InputDocument>> e2 : documentsByLanguage.entrySet()) {
                        String lang = e2.getKey();
                        if (!ClusteringActionTransport.this.context.isLanguageSupported(lang)) {
                            if (!warnOnce.add(lang)) continue;
                            ClusteringActionTransport.this.logger.warn("Language is not supported, documents in this language will not be clustered: '" + lang + "'");
                            continue;
                        }
                        LanguageComponents languageComponents = ClusteringActionTransport.this.context.getLanguageComponents(lang);
                        long tsClusteringStart = System.nanoTime();
                        clustersByLanguage.put(lang, algorithm.cluster(e2.getValue().stream(), languageComponents));
                        long tsClusteringEnd = System.nanoTime();
                        tsClusteringTotal += tsClusteringEnd - tsClusteringStart;
                    }
                    LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
                    info.put("algorithm", algorithmId);
                    info.put("search-millis", Long.toString(TimeUnit.NANOSECONDS.toMillis(tsSearchEnd - tsSearchStart)));
                    info.put("clustering-millis", Long.toString(TimeUnit.NANOSECONDS.toMillis(tsClusteringTotal)));
                    info.put("total-millis", Long.toString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - tsSearchStart)));
                    info.put("max-hits", clusteringRequest.getMaxHits() == Integer.MAX_VALUE ? "" : Integer.toString(clusteringRequest.getMaxHits()));
                    info.put("languages", String.join((CharSequence)", ", clustersByLanguage.keySet()));
                    if (clusteringRequest.getMaxHits() != Integer.MAX_VALUE) {
                        response = ClusteringActionTransport.this.filterMaxHits(response, clusteringRequest.getMaxHits());
                    }
                    AtomicInteger groupId = new AtomicInteger();
                    Map<String, DocumentGroup[]> adaptedByLanguage = clustersByLanguage.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, e -> ClusteringActionTransport.this.adapt((List)e.getValue(), groupId)));
                    ArrayList<DocumentGroup> groups = new ArrayList<DocumentGroup>();
                    adaptedByLanguage.values().forEach(langClusters -> groups.addAll(Arrays.asList(langClusters)));
                    if (adaptedByLanguage.size() > 1) {
                        groups.sort((a, b) -> Integer.compare(b.uniqueDocuments().size(), a.uniqueDocuments().size()));
                    }
                    if (clusteringRequest.createUngroupedDocumentsCluster) {
                        DocumentGroup ungrouped = new DocumentGroup();
                        ungrouped.setId(groupId.incrementAndGet());
                        ungrouped.setPhrases(new String[]{"Ungrouped documents"});
                        ungrouped.setUngroupedDocuments(true);
                        ungrouped.setScore(0.0);
                        LinkedHashSet<InputDocument> ungroupedDocuments = new LinkedHashSet<InputDocument>(documents);
                        clustersByLanguage.values().forEach(langClusters -> this.removeReferenced(ungroupedDocuments, (List<Cluster<InputDocument>>)langClusters));
                        ungrouped.setDocumentReferences((String[])ungroupedDocuments.stream().map(InputDocument::getStringId).toArray(String[]::new));
                        groups.add(ungrouped);
                    }
                    listener.onResponse((Object)new ClusteringActionResponse(response, groups.toArray(new DocumentGroup[0]), info));
                }
                catch (Exception e3) {
                    String message = "Clustering error: " + e3.getMessage();
                    ClusteringActionTransport.this.logger.warn(message, (Throwable)e3);
                    listener.onFailure((Exception)new ElasticsearchException(message, new Object[0]));
                }
            }

            private void removeReferenced(LinkedHashSet<InputDocument> ungrouped, List<Cluster<InputDocument>> clusters) {
                clusters.forEach(cluster -> {
                    ungrouped.removeAll(cluster.getDocuments());
                    this.removeReferenced(ungrouped, cluster.getClusters());
                });
            }
        });
    }

    public static <T> T requireNonNullElse(T first, T def) {
        return first != null ? first : def;
    }

    protected SearchResponse filterMaxHits(SearchResponse response, int maxHits) {
        SearchHits allHits = response.getHits();
        SearchHit[] trimmedHits = new SearchHit[Math.min(maxHits, allHits.getHits().length)];
        System.arraycopy(allHits.getHits(), 0, trimmedHits, 0, trimmedHits.length);
        InternalAggregations _internalAggregations = null;
        if (response.getAggregations() != null) {
            _internalAggregations = new InternalAggregations(this.toInternal(response.getAggregations().asList()), null);
        }
        SearchHits _searchHits = new SearchHits(trimmedHits, allHits.getTotalHits(), allHits.getMaxScore());
        SearchProfileShardResults _searchProfileShardResults = new SearchProfileShardResults(response.getProfileResults());
        InternalSearchResponse _searchResponse = new InternalSearchResponse(_searchHits, _internalAggregations, response.getSuggest(), _searchProfileShardResults, response.isTimedOut(), response.isTerminatedEarly(), response.getNumReducePhases());
        return new SearchResponse((SearchResponseSections)_searchResponse, response.getScrollId(), response.getTotalShards(), response.getSuccessfulShards(), response.getSkippedShards(), response.getTook().getMillis(), response.getShardFailures(), response.getClusters());
    }

    private List<InternalAggregation> toInternal(List<Aggregation> list) {
        ArrayList<InternalAggregation> t = new ArrayList<InternalAggregation>(list.size());
        for (Aggregation a : list) {
            t.add((InternalAggregation)a);
        }
        return t;
    }

    protected DocumentGroup[] adapt(List<Cluster<InputDocument>> clusters, AtomicInteger groupId) {
        DocumentGroup[] groups = new DocumentGroup[clusters.size()];
        for (int i = 0; i < groups.length; ++i) {
            groups[i] = this.adapt(clusters.get(i), groupId);
        }
        return groups;
    }

    private DocumentGroup adapt(Cluster<InputDocument> cluster, AtomicInteger groupId) {
        DocumentGroup group = new DocumentGroup();
        group.setId(groupId.incrementAndGet());
        group.setPhrases(cluster.getLabels().toArray(new String[0]));
        group.setScore(cluster.getScore());
        List documents = cluster.getDocuments();
        String[] documentReferences = new String[documents.size()];
        for (int i = 0; i < documentReferences.length; ++i) {
            documentReferences[i] = ((InputDocument)documents.get(i)).getStringId();
        }
        group.setDocumentReferences(documentReferences);
        group.setSubgroups(this.adapt(cluster.getClusters(), groupId));
        return group;
    }

    private List<InputDocument> prepareDocumentsForClustering(ClusteringActionRequest request, SearchResponse response) {
        SearchHit[] hits = response.getHits().getHits();
        ArrayList<InputDocument> documents = new ArrayList<InputDocument>(hits.length);
        List<FieldMappingSpec> fieldMapping = request.getFieldMapping();
        StringBuilder title = new StringBuilder();
        StringBuilder content = new StringBuilder();
        StringBuilder language = new StringBuilder();
        boolean emptySourceWarningEmitted = false;
        for (SearchHit hit : hits) {
            title.setLength(0);
            content.setLength(0);
            language.setLength(0);
            Map fields = hit.getFields();
            Map highlightFields = hit.getHighlightFields();
            Map sourceAsMap = null;
            for (FieldMappingSpec spec : fieldMapping) {
                StringBuilder target;
                Object appendContent = null;
                block0 : switch (spec.source) {
                    case FIELD: {
                        DocumentField hitField = (DocumentField)fields.get(spec.field);
                        if (hitField == null) break;
                        appendContent = hitField.getValue();
                        break;
                    }
                    case HIGHLIGHT: {
                        HighlightField highlightField = (HighlightField)highlightFields.get(spec.field);
                        if (highlightField == null) break;
                        appendContent = ClusteringActionTransport.join(Arrays.asList(highlightField.fragments()));
                        break;
                    }
                    case SOURCE: {
                        if (sourceAsMap == null) {
                            if (!hit.hasSource()) {
                                if (!emptySourceWarningEmitted) {
                                    emptySourceWarningEmitted = true;
                                    this.logger.warn("_source field mapping used but no source available for: {}, field {}", (Object)hit.getId(), (Object)spec.field);
                                }
                            } else {
                                sourceAsMap = hit.getSourceAsMap();
                            }
                        }
                        if (sourceAsMap == null) break;
                        String[] fieldNames = spec.field.split("\\.");
                        Map value = sourceAsMap;
                        for (String fieldName : fieldNames) {
                            if (Map.class.isInstance(value)) {
                                if ((value = value.get(fieldName)) != null) continue;
                                this.logger.warn("Cannot find field named '{}' from spec: '{}'", (Object)fieldName, (Object)spec.field);
                                break block0;
                            }
                            this.logger.warn("Field is not a map: {} in spec.: {}", (Object)fieldName, (Object)spec.field);
                            break block0;
                        }
                        if (value instanceof List) {
                            appendContent = ClusteringActionTransport.join((List)((Object)value));
                            break;
                        }
                        appendContent = value;
                        break;
                    }
                    default: {
                        throw Preconditions.unreachable();
                    }
                }
                if (appendContent == null) continue;
                switch (spec.logicalField) {
                    case LANGUAGE: {
                        language.setLength(0);
                        target = language;
                        break;
                    }
                    case TITLE: {
                        target = title;
                        break;
                    }
                    case CONTENT: {
                        target = content;
                        break;
                    }
                    default: {
                        throw Preconditions.unreachable();
                    }
                }
                if (target.length() > 0) {
                    target.append(" . ");
                }
                target.append(appendContent);
            }
            String langCode = language.length() > 0 ? language.toString() : null;
            InputDocument doc = new InputDocument(title.toString(), content.toString(), langCode, hit.getId());
            documents.add(doc);
        }
        return documents;
    }

    static String join(List<?> list) {
        StringBuilder sb = new StringBuilder();
        for (Object t : list) {
            if (sb.length() > 0) {
                sb.append(" . ");
            }
            sb.append(t != null ? t.toString() : "");
        }
        return sb.toString();
    }

    private final class TransportHandler
    implements TransportRequestHandler<ClusteringActionRequest> {
        private TransportHandler() {
        }

        public void messageReceived(final ClusteringActionRequest request, final TransportChannel channel, Task task) {
            ClusteringActionTransport.this.execute(request, (ActionListener)new ActionListener<ClusteringActionResponse>(){

                public void onResponse(ClusteringActionResponse response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        ClusteringActionTransport.this.logger.warn("Failed to send error response for action [indices:data/read/cluster] and request [" + request + "]", (Throwable)e1);
                    }
                }
            });
        }
    }
}

