/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.carrot2.clustering.ClusteringAlgorithm;
import org.carrot2.clustering.ClusteringAlgorithmProvider;
import org.carrot2.elasticsearch.PathResourceLookup;
import org.carrot2.language.LanguageComponents;
import org.carrot2.language.LanguageComponentsLoader;
import org.carrot2.language.LanguageComponentsProvider;
import org.carrot2.language.LoadedLanguages;
import org.carrot2.util.ChainedResourceLookup;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;

public class ClusteringContext
extends AbstractLifecycleComponent {
    public static final String PROP_RESOURCES = "resources";
    private final Environment environment;
    private final LinkedHashMap<String, ClusteringAlgorithmProvider> algorithmProviders;
    private final LinkedHashMap<String, List<LanguageComponentsProvider>> languageComponentProviders;
    private LinkedHashMap<String, LanguageComponents> languages;
    private Logger logger;

    public ClusteringContext(Environment environment, LinkedHashMap<String, ClusteringAlgorithmProvider> algorithmProviders, LinkedHashMap<String, List<LanguageComponentsProvider>> languageComponentProviders) {
        this.environment = environment;
        this.logger = LogManager.getLogger((String)"plugin.carrot2");
        this.algorithmProviders = algorithmProviders;
        this.languageComponentProviders = languageComponentProviders;
    }

    @SuppressForbidden(reason="C2 integration (File API)")
    protected void doStart() throws ElasticsearchException {
        try {
            Path esConfig = this.environment.configFile();
            Path pluginConfigPath = esConfig.resolve("elasticsearch-carrot2");
            if (!Files.isDirectory(pluginConfigPath, new LinkOption[0])) {
                throw new ElasticsearchException("Missing configuration folder?: {}", new Object[]{pluginConfigPath});
            }
            Settings.Builder builder = Settings.builder();
            for (String configName : new String[]{"config.yml", "config.yaml", "config.json", "config.properties"}) {
                Path resolved = pluginConfigPath.resolve(configName);
                if (!Files.exists(resolved, new LinkOption[0])) continue;
                builder.loadFromPath(resolved);
            }
            Settings c2Settings = builder.build();
            List resourceLocations = c2Settings.getAsList(PROP_RESOURCES).stream().map(p -> esConfig.resolve((String)p).toAbsolutePath()).filter(p -> {
                boolean exists = Files.exists(p, new LinkOption[0]);
                if (!exists) {
                    this.logger.info("Clustering algorithm resource location does not exist, ignored: {}", p);
                }
                return exists;
            }).collect(Collectors.toList());
            LanguageComponentsLoader loader = LanguageComponents.loader();
            if (!resourceLocations.isEmpty()) {
                this.logger.info("Clustering algorithm resources first looked up relative to: {}", resourceLocations);
                loader.withResourceLookup(provider -> new ChainedResourceLookup(Arrays.asList(new PathResourceLookup(resourceLocations), provider.defaultResourceLookup())));
            } else {
                this.logger.info("Resources read from defaults (JARs).");
            }
            loader.limitToAlgorithms((ClusteringAlgorithm[])this.algorithmProviders.values().stream().map(Supplier::get).toArray(ClusteringAlgorithm[]::new));
            AccessController.doPrivileged(() -> {
                this.languages = new LinkedHashMap();
                LoadedLanguages loadedLanguages = loader.load(this.languageComponentProviders);
                for (String lang : loadedLanguages.languages()) {
                    this.languages.put(lang, loadedLanguages.language(lang));
                }
                if (this.logger.isDebugEnabled()) {
                    for (String lang : loadedLanguages.languages()) {
                        this.logger.trace("Loaded language '" + lang + "' with components: \n  - " + loadedLanguages.language(lang).components().stream().map(c -> c.getSimpleName()).collect(Collectors.joining("\n  - ")));
                    }
                }
                this.algorithmProviders.entrySet().removeIf(e -> !this.isAlgorithmAvailable((ClusteringAlgorithmProvider)e.getValue(), this.languages.values()));
                this.algorithmProviders.forEach((name, prov) -> {
                    String supportedLanguages = this.languages.values().stream().filter(lc -> ((ClusteringAlgorithm)prov.get()).supports(lc)).map(LanguageComponents::language).collect(Collectors.joining(", "));
                    this.logger.info("Clustering algorithm {} loaded with support for the following languages: {}", name, (Object)supportedLanguages);
                });
                return null;
            });
        }
        catch (Exception e) {
            throw new ElasticsearchException("Could not initialize clustering.", (Throwable)e, new Object[0]);
        }
        if (this.algorithmProviders.isEmpty()) {
            throw new ElasticsearchException("No registered/ available clustering algorithms? Check the logs, it's odd.", new Object[0]);
        }
    }

    public LinkedHashMap<String, ClusteringAlgorithmProvider> getAlgorithms() {
        return this.algorithmProviders;
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    public LanguageComponents getLanguageComponents(String lang) {
        return this.languages.get(lang);
    }

    public boolean isLanguageSupported(String langCode) {
        return this.languages.containsKey(langCode);
    }

    private boolean isAlgorithmAvailable(ClusteringAlgorithmProvider provider, Collection<LanguageComponents> languages) {
        ClusteringAlgorithm algorithm = (ClusteringAlgorithm)provider.get();
        Optional<LanguageComponents> first = languages.stream().filter(arg_0 -> ((ClusteringAlgorithm)algorithm).supports(arg_0)).findFirst();
        if (first.isEmpty()) {
            this.logger.warn("Algorithm does not support any of the available languages: {}", (Object)provider.name());
            return false;
        }
        return true;
    }
}

