/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.carrot2.clustering.ClusteringAlgorithmProvider;
import org.carrot2.elasticsearch.ClusteringAction;
import org.carrot2.elasticsearch.ClusteringActionTransport;
import org.carrot2.elasticsearch.ClusteringContext;
import org.carrot2.elasticsearch.ListAlgorithmsAction;
import org.carrot2.language.LanguageComponentsProvider;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;

public class ClusteringPlugin
extends Plugin
implements ExtensiblePlugin,
ActionPlugin {
    public static final String DEFAULT_ENABLED_PROPERTY_NAME = "carrot2.enabled";
    public static final String PLUGIN_NAME = "elasticsearch-carrot2";
    private LinkedHashMap<String, ClusteringAlgorithmProvider> algorithmProviders = new LinkedHashMap();
    private Map<String, List<LanguageComponentsProvider>> languageComponentProviders = new LinkedHashMap<String, List<LanguageComponentsProvider>>();
    private final boolean transportClient;
    private final boolean pluginEnabled;

    public ClusteringPlugin(Settings settings) {
        this.pluginEnabled = settings.getAsBoolean(DEFAULT_ENABLED_PROPERTY_NAME, Boolean.valueOf(true));
        this.transportClient = "transport".equals(Client.CLIENT_TYPE_SETTING_S.get(settings));
        this.loadExtensions(((Object)((Object)this)).getClass().getClassLoader());
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (this.pluginEnabled) {
            return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)ClusteringAction.INSTANCE, ClusteringActionTransport.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ListAlgorithmsAction.INSTANCE, ListAlgorithmsAction.TransportListAlgorithmsAction.class, new Class[0]));
        }
        return Collections.emptyList();
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestHandler[]{new ClusteringAction.RestClusteringAction(), new ListAlgorithmsAction.RestListAlgorithmsAction()});
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.pluginEnabled && !this.transportClient) {
            components.add((Object)new ClusteringContext(environment, this.reorderAlgorithms(this.algorithmProviders), new LinkedHashMap<String, List<LanguageComponentsProvider>>(this.languageComponentProviders)));
        }
        return components;
    }

    private LinkedHashMap<String, ClusteringAlgorithmProvider> reorderAlgorithms(LinkedHashMap<String, ClusteringAlgorithmProvider> providers) {
        String[] desiredOrder = new String[]{"Lingo3G", "Lingo", "STC", "Bisecting K-Means"};
        LinkedHashMap<String, ClusteringAlgorithmProvider> copy = new LinkedHashMap<String, ClusteringAlgorithmProvider>();
        for (String name2 : desiredOrder) {
            if (!providers.containsKey(name2)) continue;
            copy.put(name2, providers.get(name2));
        }
        providers.forEach((name, provider) -> {
            if (!copy.containsKey(name)) {
                copy.put((String)name, (ClusteringAlgorithmProvider)provider);
            }
        });
        return copy;
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.loadExtensions(loader.loadExtensions(ClusteringAlgorithmProvider.class), loader.loadExtensions(LanguageComponentsProvider.class));
    }

    private void loadExtensions(ClassLoader classLoader) {
        this.loadExtensions(ServiceLoader.load(ClusteringAlgorithmProvider.class, classLoader), ServiceLoader.load(LanguageComponentsProvider.class, classLoader));
    }

    private void loadExtensions(Iterable<ClusteringAlgorithmProvider> clusteringAlgorithmProviders, Iterable<LanguageComponentsProvider> languageComponentsProviders) {
        clusteringAlgorithmProviders.forEach(provider -> {
            String name = provider.name();
            if (this.algorithmProviders.containsKey(name)) {
                throw new RuntimeException("More than one provider for algorithm " + name + "?");
            }
            this.algorithmProviders.put(name, (ClusteringAlgorithmProvider)provider);
        });
        languageComponentsProviders.forEach(provider -> {
            for (String lang : provider.languages()) {
                this.languageComponentProviders.computeIfAbsent(lang, k -> new ArrayList()).add(provider);
            }
        });
    }
}

