/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.carrot2.elasticsearch.Preconditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;

public class DocumentGroup
implements ToXContent,
Writeable {
    private static final DocumentGroup[] EMPTY_DOC_GROUP = new DocumentGroup[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private int id;
    private String[] phrases = EMPTY_STRING_ARRAY;
    private double score;
    private String[] documentReferences = EMPTY_STRING_ARRAY;
    private DocumentGroup[] subgroups = EMPTY_DOC_GROUP;
    private boolean ungroupedDocuments;
    private Set<String> uniqueDocuments;

    public DocumentGroup() {
    }

    DocumentGroup(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.score = in.readDouble();
        this.phrases = in.readStringArray();
        this.ungroupedDocuments = in.readBoolean();
        this.documentReferences = in.readStringArray();
        int max = in.readVInt();
        this.subgroups = new DocumentGroup[max];
        for (int i = 0; i < max; ++i) {
            this.subgroups[i] = new DocumentGroup(in);
        }
    }

    public DocumentGroup[] getSubgroups() {
        return this.subgroups;
    }

    public void setSubgroups(DocumentGroup[] subclusters) {
        this.subgroups = Preconditions.checkNotNull(subclusters);
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setPhrases(String[] phrases) {
        this.phrases = Preconditions.checkNotNull(phrases);
    }

    public String[] getPhrases() {
        return this.phrases;
    }

    public String getLabel() {
        return String.join((CharSequence)", ", this.getPhrases());
    }

    public void setScore(Double score) {
        this.score = score == null ? 0.0 : score;
    }

    public double getScore() {
        return this.score;
    }

    public void setDocumentReferences(String[] documentReferences) {
        this.documentReferences = Preconditions.checkNotNull(documentReferences);
    }

    public String[] getDocumentReferences() {
        return this.documentReferences;
    }

    public void setUngroupedDocuments(boolean ungroupedDocuments) {
        this.ungroupedDocuments = ungroupedDocuments;
    }

    public boolean isUngroupedDocuments() {
        return this.ungroupedDocuments;
    }

    public Set<String> uniqueDocuments() {
        if (this.uniqueDocuments == null) {
            this.uniqueDocuments = new HashSet<String>();
            this.uniqueDocuments.addAll(Arrays.asList(this.getDocumentReferences()));
            for (DocumentGroup group : this.subgroups) {
                this.uniqueDocuments.addAll(group.uniqueDocuments);
            }
        }
        return this.uniqueDocuments;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeDouble(this.score);
        out.writeStringArray(this.phrases);
        out.writeBoolean(this.ungroupedDocuments);
        out.writeStringArray(this.documentReferences);
        out.writeVInt(this.subgroups.length);
        for (DocumentGroup group : this.subgroups) {
            group.writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id).field("score", this.score).field("label", this.getLabel()).array("phrases", this.phrases);
        if (this.ungroupedDocuments) {
            builder.field("other_topics", this.ungroupedDocuments);
        }
        if (this.documentReferences.length > 0) {
            builder.array("documents", this.documentReferences);
        }
        if (this.subgroups.length > 0) {
            builder.startArray("clusters");
            for (DocumentGroup group : this.subgroups) {
                group.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            this.toXContent(builder, EMPTY_PARAMS);
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }
}

