/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

enum FieldSource {
    HIGHLIGHT("highlight."),
    FIELD("fields."),
    SOURCE("_source.");

    private final String fieldSpecPrefix;
    static FieldSource[] cachedByOrdinal;

    static ParsedFieldSource parseSpec(String fieldSourceSpec) {
        if (fieldSourceSpec != null) {
            for (FieldSource fs : cachedByOrdinal) {
                if (!fieldSourceSpec.startsWith(fs.fieldSpecPrefix)) continue;
                return new ParsedFieldSource(fs, fieldSourceSpec.substring(fs.fieldSpecPrefix.length()));
            }
        }
        return null;
    }

    static FieldSource fromOrdinal(int ordinal) {
        return cachedByOrdinal[ordinal];
    }

    private FieldSource(String fieldSpecPrefix) {
        this.fieldSpecPrefix = fieldSpecPrefix;
    }

    static {
        cachedByOrdinal = FieldSource.values();
    }

    static class ParsedFieldSource {
        final FieldSource source;
        final String fieldName;

        ParsedFieldSource(FieldSource source, String fieldName) {
            this.source = source;
            this.fieldName = fieldName;
        }
    }
}

