/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.carrot2.elasticsearch.ClusteringContext;
import org.carrot2.elasticsearch.LoggerUtils;
import org.carrot2.elasticsearch.ToString;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ListAlgorithmsAction
extends ActionType<ListAlgorithmsActionResponse> {
    public static final String NAME = "cluster:monitor/carrot2/algorithms";
    public static final ListAlgorithmsAction INSTANCE = new ListAlgorithmsAction();

    private ListAlgorithmsAction() {
        super(NAME, ListAlgorithmsActionResponse::new);
    }

    public Writeable.Reader<ListAlgorithmsActionResponse> getResponseReader() {
        return ListAlgorithmsActionResponse::new;
    }

    public static class RestListAlgorithmsAction
    extends BaseRestHandler {
        public static String NAME = "_algorithms";
        protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

        public List<RestHandler.Route> routes() {
            return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/" + NAME), new RestHandler.Route(RestRequest.Method.GET, "/" + NAME));
        }

        public String getName() {
            return NAME;
        }

        public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) {
            if (request.hasContent()) {
                return channel -> LoggerUtils.emitErrorResponse(channel, this.logger, new IllegalArgumentException("Request body was expected."));
            }
            ListAlgorithmsActionRequest actionRequest = new ListAlgorithmsActionRequest();
            return channel -> client.execute((ActionType)INSTANCE, (ActionRequest)actionRequest, (ActionListener)new ActionListener<ListAlgorithmsActionResponse>(){

                public void onResponse(ListAlgorithmsActionResponse response) {
                    try {
                        XContentBuilder builder = channel.newBuilder();
                        builder.startObject();
                        response.toXContent(builder, (ToXContent.Params)request);
                        builder.endObject();
                        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, builder));
                    }
                    catch (Exception e) {
                        logger.debug("Failed to emit response.", (Throwable)e);
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    LoggerUtils.emitErrorResponse(channel, logger, e);
                }
            });
        }
    }

    public static class TransportListAlgorithmsAction
    extends TransportAction<ListAlgorithmsActionRequest, ListAlgorithmsActionResponse> {
        protected Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        private final ClusteringContext controllerSingleton;

        @Inject
        public TransportListAlgorithmsAction(TransportService transportService, ClusteringContext controllerSingleton, ActionFilters actionFilters) {
            super(ListAlgorithmsAction.NAME, actionFilters, transportService.getTaskManager());
            this.controllerSingleton = controllerSingleton;
            transportService.registerRequestHandler(ListAlgorithmsAction.NAME, "same", ListAlgorithmsActionRequest::new, (TransportRequestHandler)new TransportHandler());
        }

        protected void doExecute(Task task, ListAlgorithmsActionRequest request, ActionListener<ListAlgorithmsActionResponse> listener) {
            listener.onResponse((Object)new ListAlgorithmsActionResponse(new ArrayList<String>(this.controllerSingleton.getAlgorithms().keySet())));
        }

        private final class TransportHandler
        implements TransportRequestHandler<ListAlgorithmsActionRequest> {
            private TransportHandler() {
            }

            public void messageReceived(final ListAlgorithmsActionRequest request, final TransportChannel channel, Task task) throws Exception {
                TransportListAlgorithmsAction.this.execute(request, (ActionListener)new ActionListener<ListAlgorithmsActionResponse>(){

                    public void onResponse(ListAlgorithmsActionResponse response) {
                        try {
                            channel.sendResponse((TransportResponse)response);
                        }
                        catch (Exception e) {
                            this.onFailure(e);
                        }
                    }

                    public void onFailure(Exception e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Exception e1) {
                            TransportListAlgorithmsAction.this.logger.warn("Failed to send error response for action [cluster:monitor/carrot2/algorithms] and request [" + request + "]", (Throwable)e1);
                        }
                    }
                });
            }
        }
    }

    public static class ListAlgorithmsActionResponse
    extends ActionResponse
    implements ToXContent {
        private static final String[] EMPTY_LIST = new String[0];
        private String[] algorithms;

        public ListAlgorithmsActionResponse(StreamInput in) throws IOException {
            super(in);
            this.algorithms = in.readStringArray();
        }

        public ListAlgorithmsActionResponse(List<String> algorithms) {
            this.algorithms = algorithms.toArray(new String[0]);
        }

        public List<String> getAlgorithms() {
            return Collections.unmodifiableList(Arrays.asList(this.algorithms));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.array("algorithms", this.algorithms);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.algorithms);
        }

        public String toString() {
            return ToString.objectToJson(this);
        }

        static final class Fields {
            static final String ALGORITHMS = "algorithms";

            Fields() {
            }
        }
    }

    public static class ListAlgorithmsActionRequestBuilder
    extends ActionRequestBuilder<ListAlgorithmsActionRequest, ListAlgorithmsActionResponse> {
        public ListAlgorithmsActionRequestBuilder(ElasticsearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new ListAlgorithmsActionRequest());
        }
    }

    public static class ListAlgorithmsActionRequest
    extends ActionRequest {
        ListAlgorithmsActionRequest() {
        }

        ListAlgorithmsActionRequest(StreamInput in) throws IOException {
            super(in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }
    }
}

