package caseine.project;

import java.io.IOException;

import caseine.tools.vplwsclient.exception.VplException;

public interface CaseineProject {

	public enum ProjectType {
		JAVA, MAVEN, PYTHON, CPP
	}


	/**
	 * 
	 * @return True if it is a Caseine project
	 */
	 boolean isCaseine();

	 ProjectType getType();

	 String getVplId();

	/**
	 * Generates the project template.
	 * @param mvn True if we must generate the maven pom.xml
	 * 
	 * @throws CaseineProjectAlreadyExistingException
	 * @throws BadIDEException
	 * @throws IOException
	 */
	 void generate(boolean mvn) throws CaseineProjectAlreadyExistingException, BadIDEException, IOException;
	
	/**
	 * Generates the local caseine templates into caseine-output.
	 * 
	 * @throws IOException if ioException
	 * @throws ClassNotFoundException if the class is not found
	 * @throws MavenProjectException 
	 */
	 void local() throws IOException, ClassNotFoundException, MavenProjectException;

	/**
	 * Publishes the templates to the remote caseine server.
	 * 
	 * @throws IOException            if something wrong
	 * @throws ClassNotFoundException if something wrong
	 * @throws VplException           if something wrong
	 * @throws VPLIDMissingException
	 * @throws MavenProjectException 
	 */
	 void push() throws IOException, ClassNotFoundException, VplException, VPLIDMissingException, MavenProjectException;
	
	/**
	 * Cleans the local templates.
	 * 
	 * @throws IOException if an error occurs with the deleted files
	 */
	 void clean() throws IOException;


	/*
	 * 
	 * @return True if the Caseine project is generated locally
	 */
	public boolean isGenerated();

	/**
	 * Set the caseine nature to the project
	 * @throws CaseineProjectAlreadyExistingException
	 * @throws IOException
	 */
	void nature() throws CaseineProjectAlreadyExistingException, IOException;
}
