/*
 * Decompiled with CFR 0.152.
 */
package caseine.goals;

import caseine.CaseineCommand;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="push", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PushMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(property="vplid", defaultValue="0")
    private String vplid;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        PushMojo.execute(this.basedir, this.project, this.vplid, this.getLog());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(File basedir, MavenProject project, String vplid, Log log) throws MojoExecutionException {
        URLClassLoader contextClassLoader = null;
        try {
            HashSet<URL> urls = new HashSet<URL>();
            List elements = project.getCompileClasspathElements();
            for (String element : elements) {
                urls.add(new File(element).toURI().toURL());
            }
            contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), CaseineCommand.class.getClassLoader());
            log.info((CharSequence)("Location: " + basedir.getAbsolutePath()));
            CaseineCommand.local((String)basedir.getAbsolutePath(), (String)vplid, (ClassLoader)contextClassLoader);
        }
        catch (ClassNotFoundException e) {
            log.error((CharSequence)"No class found, try to compile the lab ...");
            log.error(e.getCause());
        }
        catch (IllegalArgumentException | NoClassDefFoundError e) {
            log.debug((CharSequence)"Conditions are not met to do the push, the command is inhibited");
        }
        catch (Exception e) {
            log.warn((CharSequence)e.getMessage());
        }
        finally {
            if (contextClassLoader != null) {
                try {
                    contextClassLoader.close();
                }
                catch (IOException e) {
                    log.error((CharSequence)e.getMessage());
                }
            }
        }
    }
}

