/*
 * Decompiled with CFR 0.152.
 */
package caseine.goals;

import caseine.CaseineCommand;
import caseine.project.MavenProjectException;
import caseine.project.VPLIDMissingException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import vplwsclient.exception.VplException;

@Mojo(name="push-moodle", requiresDependencyResolution=ResolutionScope.COMPILE)
public class PushMoodleMojo
extends AbstractMojo {
    @Parameter(property="url", defaultValue="")
    private String url;
    @Parameter(property="token", defaultValue="")
    private String token;
    @Parameter(property="vplid", defaultValue="0")
    private String vplid;
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="no-settings", defaultValue="false", required=false)
    private String noSettings;
    @Parameter(property="no-local", defaultValue="false", required=false)
    private boolean noLocal;

    private boolean isNoSettings() {
        return !this.noSettings.toLowerCase().equals("false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Server: " + this.url + ", vplId: " + this.vplid));
        this.getLog().info((CharSequence)("No Settings: " + this.noSettings));
        if (!this.vplid.equals("0")) {
            URLClassLoader contextClassLoader = null;
            try {
                HashSet<URL> urls = new HashSet<URL>();
                List elements = this.project.getCompileClasspathElements();
                for (String element : elements) {
                    urls.add(new File(element).toURI().toURL());
                }
                contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), CaseineCommand.class.getClassLoader());
                this.getLog().info((CharSequence)("Location: " + this.basedir.getAbsolutePath()));
                CaseineCommand.push((String)this.basedir.getAbsolutePath(), (String)this.vplid, (String)this.url, (String)this.token, (ClassLoader)contextClassLoader, (boolean)this.isNoSettings(), (boolean)this.noLocal);
            }
            catch (MavenProjectException | VPLIDMissingException | IOException | VplException e) {
                this.getLog().error(e);
            }
            catch (ClassNotFoundException e) {
                this.getLog().error((CharSequence)"No class found, try to compile the lab ...");
                this.getLog().error(e.getCause());
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
            finally {
                if (contextClassLoader != null) {
                    try {
                        contextClassLoader.close();
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)e.getMessage());
                    }
                }
            }
        }
    }
}

