/*
 * Decompiled with CFR 0.152.
 */
package caseine.checker;

import caseine.tags.CheckModifier;
import caseine.tags.GetterToCheck;
import caseine.tags.SetterToCheck;
import caseine.tags.ToCheck;
import caseine.tags.ToCompare;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.body.BodyDeclaration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Checker
implements Iterable<BodyDeclaration<?>> {
    private final StringBuilder SB;
    private final TreeMap<String, StringBuilder> MSBall;
    private final TreeMap<String, BodyDeclaration<?>> BDall;
    private final Formatter F;
    private final Class<?> C;

    private Checker(Class<?> c, TreeMap<String, StringBuilder> msb, TreeMap<String, BodyDeclaration<?>> bdall) {
        this.MSBall = msb;
        this.BDall = bdall;
        this.SB = new StringBuilder();
        this.F = new Formatter(this.SB, Locale.US);
        this.C = c;
        this.check();
    }

    public Checker(Class<?> c) {
        this(c, new TreeMap<String, StringBuilder>(), new TreeMap());
    }

    public Checker(Class<?> c, Checker chk) {
        this(c, chk.MSBall, chk.BDall);
    }

    private void f(String format, Formatter f, Object ... o) {
        f.format(format, o);
        this.F.format(format, o);
    }

    private void check() {
        ToCheck annotation = this.C.getAnnotation(ToCheck.class);
        if (annotation != null) {
            this.checkClass(annotation);
        }
        this.checkFields();
        this.checkConstructors();
        this.checkMethods();
        this.checkSetters();
        this.checkGetters();
        this.testMethods();
        this.checkInnerClasses();
    }

    private void put(String testMethodName, StringBuilder sb) {
        this.MSBall.put(testMethodName, sb);
        this.BDall.put(testMethodName, StaticJavaParser.parseBodyDeclaration((String)sb.toString()));
    }

    public void checkClass(ToCheck toCheck) {
        String testMethodName = String.format("p%06d000_checkClass%s()", toCheck.priority(), this.C.getSimpleName());
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"check class %s\");\n", formatter, this.C.getSimpleName());
        this.f("   try {\n", formatter, new Object[0]);
        try {
            this.f("   \t\tassertTrue(\"%s\", ReflectUtilities.parseType(\"%s\").getSuperclass().equals(ReflectUtilities.parseType(\"%s\")));\n", formatter, toCheck.value() + " (Inheritance)", this.C.getName(), this.C.getSuperclass().getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.f("   \t\tClass<?> x = ReflectUtilities.parseType(\"%s\");\n", formatter, this.C.getName());
        this.checkModifiers(toCheck.value(), this.C.getModifiers(), toCheck.modifiers(), formatter);
        this.f("   } catch (ClassNotFoundException ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"%s\");\n", formatter, "Class " + this.C.getSimpleName() + " not found");
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkImplementations(ToCheck toCheck, Formatter formatter) {
        List implementations = Arrays.stream(this.C.getInterfaces()).sorted((i1, i2) -> i1.getName().compareTo(i2.getName())).collect(Collectors.toList());
        this.f("   List<Class<?>> implementations = Arrays.stream(x.getInterfaces())\n", formatter, new Object[0]);
    }

    private void checkConstructor(Constructor<?> c, ToCheck toCheck) {
        String msg = toCheck.value().isEmpty() ? "Constructor of " + c.getName() : toCheck.value();
        StringBuilder params = Arrays.stream(c.getParameterTypes()).map(x -> x.getSimpleName().replaceAll("\\[\\]", "Array")).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
        String testMethodName = String.format("p%06d000_checkConstructor%s%s()", toCheck.priority(), this.C.getSimpleName(), params.toString());
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Declaration of %s\");\n", formatter, msg);
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Constructor x =  ReflectUtilities.parseType(\"%s\").getDeclaredConstructor(\n", formatter, this.C.getName());
        if (c.getParameterCount() > 0) {
            Class<?>[] tparam = c.getParameterTypes();
            this.f("           ReflectUtilities.parseType(\"%s\")", formatter, tparam[0].getName());
            for (int i = 1; i < tparam.length; ++i) {
                this.f(",\n           ReflectUtilities.parseType(\"%s\")", formatter, tparam[i].getName());
            }
        }
        this.f("\n        );\n", formatter, new Object[0]);
        this.checkModifiers(toCheck.value(), c.getModifiers(), toCheck.modifiers(), formatter);
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"%s\");\n", formatter, msg);
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkConstructors() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredConstructors()).filter(c -> c.getAnnotation(ToCheck.class) != null).forEach(c -> this.checkConstructor((Constructor<?>)c, c.getAnnotation(ToCheck.class)));
    }

    private void compareConstructor(Constructor<?> c, ToCheck toCheck, ToCompare toCompare) {
        String msg = toCheck.value().isEmpty() ? "Constructor of " + c.getName() : toCheck.value();
        StringBuilder params = Arrays.stream(c.getParameterTypes()).map(x -> x.getSimpleName().replaceAll("\\[\\]", "Array")).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
        String testMethodName = String.format("p%06d000_testConstructor%s%s()", toCompare.priority(), this.C.getSimpleName(), params.toString());
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Test %s\");\n", formatter, msg);
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Constructor x = ReflectUtilities.parseType(\"%s\").getDeclaredConstructor(\n", formatter, this.C.getName());
        if (c.getParameterCount() > 0) {
            Class<?>[] tparam = c.getParameterTypes();
            this.f("           ReflectUtilities.parseType(\"%s\")", formatter, tparam[0].getName());
            for (int i = 1; i < tparam.length; ++i) {
                this.f(",\n           ReflectUtilities.parseType(\"%s\")", formatter, tparam[i].getName());
            }
        }
        this.f("\n        );\n", formatter, new Object[0]);
        this.checkModifiers(toCheck.value(), c.getModifiers(), toCheck.modifiers(), formatter);
        this.f("   } catch (NoSuchMethodException | SecurityException | ClassNotFoundException ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"%s\");\n", formatter, msg);
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void testMethods() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredMethods()).filter(m -> m.getAnnotation(ToCompare.class) != null).forEach(m -> {
            ToCompare toCompare = m.getAnnotation(ToCompare.class);
            this.testMethod((Method)m, toCompare);
        });
    }

    private void testMethod(Method m, ToCompare toCompare) {
        String testMethodName = String.format("p%06d000_testMethod%s%s%s()", toCompare.priority(), this.C.getSimpleName(), m.getName(), this.paramsToString(m));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCompare.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCompare.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Test Method %s.%s\");\n", formatter, this.C.getSimpleName(), m.getName());
        this.f("   try {\n", formatter, new Object[0]);
        this.f("   \tClass<?> classRef = cf.%s.class;\n", formatter, this.C.getName());
        this.f("   \tClass<?> classToTest = ReflectUtilities.parseType(\"%s\");\n", formatter, this.C.getName());
        this.f("   \tfor (int i = 0; i < 100; ++i) {\n", formatter, new Object[0]);
        this.f("         StringBuilder msg = new StringBuilder(\"Fix %s.%s() --> \");\n", formatter, this.C.getSimpleName(), m.getName());
        if (m.getParameterCount() == 0) {
            this.f("         boolean result = ReflectUtilities.sameResult(msg, classRef, classToTest, \"%s\");\n", formatter, m.getName());
        } else {
            StringBuilder parameterTypes = new StringBuilder();
            for (Class<?> type : m.getParameterTypes()) {
                parameterTypes.append(", ").append(type.getName()).append(".class");
            }
            this.f("         boolean result = ReflectUtilities.sameResult(msg, classRef, classToTest, \"%s\" %s);\n", formatter, m.getName(), parameterTypes);
        }
        if (toCompare.value().isEmpty()) {
            this.f("         assertTrue(msg.toString(), result);\n", formatter, new Object[0]);
        } else {
            this.f("         assertTrue(\"%s\", result);\n", formatter, toCompare.value());
        }
        this.f("   \t}\n", formatter, new Object[0]);
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("         fail(\"Fix %s.%s() \");\n", formatter, this.C.getSimpleName(), m.getName());
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkFields() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredFields()).filter(x -> x.getAnnotation(ToCheck.class) != null).forEach(c -> this.checkField((Field)c, c.getAnnotation(ToCheck.class)));
    }

    private void checkField(Field f, ToCheck toCheck) {
        String testMethodName = String.format("p%06d000_check%sField%s()", toCheck.priority(), this.C.getSimpleName(), this.initial(f.getName()));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Check attribute %s\");\n", formatter, f.getName());
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Field x = ReflectUtilities.parseType(\"%s\").getDeclaredField(\"%s\");\n", formatter, this.C.getName(), f.getName());
        this.checkModifiers(toCheck.value(), f.getModifiers(), toCheck.modifiers(), formatter);
        this.f("        assertTrue(\"%s\", x.getType().equals(ReflectUtilities.parseType(\"%s\")));\n", formatter, toCheck.value(), f.getType().getName());
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"%s\");\n", formatter, toCheck.value());
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkSetters() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredFields()).filter(x -> x.getAnnotation(SetterToCheck.class) != null).forEach(f -> this.checkSetter((Field)f, f.getAnnotation(SetterToCheck.class)));
    }

    private void checkSetter(Field f, SetterToCheck toCheck) {
        String testMethodName = String.format("p%06d000_checkSetter%s%s()", toCheck.priority(), this.C.getSimpleName(), f.getName());
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Check setter %s\");\n", formatter, f.getName());
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Method x = ReflectUtilities.parseType(\"%s\").getDeclaredMethod(\"set%s\", ReflectUtilities.parseType(\"%s\"));\n", formatter, this.C.getName(), this.initial(f.getName()), f.getType().getName());
        this.f("        assertTrue(\"Fix set%s\", x.getReturnType().equals(void.class));\n", formatter, this.initial(f.getName()));
        this.f("        Object o = ReflectUtilities.randomValue(ReflectUtilities.parseType(\"%s\"));\n", formatter, this.C.getName());
        this.f("        for(int i = 0; i < 100; ++i) {\n", formatter, new Object[0]);
        this.f("            %1$s v = (%1$s) ReflectUtilities.randomValue(%1$s.class);\n", formatter, f.getType().getSimpleName());
        this.f("            ReflectUtilities.getFromMethodTA(\n", formatter, new Object[0]);
        this.f("                 ReflectUtilities.parseType(\"%s\"),\n", formatter, this.C.getName());
        this.f("                 o,\n", formatter, new Object[0]);
        this.f("                 \"set%s\",\n", formatter, this.initial(f.getName()));
        this.f("                 ReflectUtilities.parseType(\"%s\"),\n", formatter, f.getType().getName());
        this.f("                 v\n", formatter, new Object[0]);
        this.f("            );\n", formatter, new Object[0]);
        this.f("            assertTrue(\"Fix set%s\", \n", formatter, this.initial(f.getName()));
        this.f("                 ReflectUtilities.getAttribut(\n", formatter, new Object[0]);
        this.f("                 ReflectUtilities.parseType(\"%s\"), \n", formatter, this.C.getName());
        this.f("                 o, \n", formatter, new Object[0]);
        this.f("                 \"%s\").equals(v)\n", formatter, f.getName());
        this.f("            );\n", formatter, new Object[0]);
        this.f("        }\n", formatter, new Object[0]);
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"Fix set%s\");\n", formatter, this.initial(f.getName()));
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkGetters() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredFields()).filter(x -> x.getAnnotation(GetterToCheck.class) != null).forEach(f -> this.checkGetter((Field)f, f.getAnnotation(GetterToCheck.class)));
    }

    private void checkGetter(Field f, GetterToCheck toCheck) {
        String className = this.C.getName();
        String attributName = f.getName();
        String getterName = "get" + this.initial(f.getName());
        String testMethodName = String.format("p%06d000_checkGetter%s%s()", toCheck.priority(), this.C.getSimpleName(), this.initial(f.getName()));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Check getter %s\");\n", formatter, attributName);
        this.f("   try {\n", formatter, new Object[0]);
        this.f("     for(int i = 0; i < 100; ++i) {\n", formatter, new Object[0]);
        this.f("         Object o = ReflectUtilities.randomValue(ReflectUtilities.parseType(\"%s\")); \n", formatter, className);
        this.f("         Object attr = ReflectUtilities.getAttribut(ReflectUtilities.parseType(\"%s\"), o, \"%s\");\n", formatter, className, attributName);
        this.f("         Object getAttr = ReflectUtilities.getFromMethod(ReflectUtilities.parseType(\"%s\"), o, \"%s\");\n", formatter, className, getterName);
        this.f("         assertTrue(\"Fix %s\", ReflectUtilities.equals(attr, getAttr));\n", formatter, getterName);
        this.f("     }\n", formatter, new Object[0]);
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"Fix %s\");\n", formatter, getterName);
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    private void checkModifiers(String msg, long modifier, CheckModifier[] modifiers, Formatter formatter) {
        for (CheckModifier cm : modifiers) {
            this.f("        " + cm.toString(), formatter, msg, modifier);
        }
    }

    public void checkMethods() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredMethods()).filter(m -> m.getAnnotation(ToCheck.class) != null).forEach(m -> {
            ToCheck toCheck = m.getAnnotation(ToCheck.class);
            this.checkMethod((Method)m, toCheck);
        });
    }

    private String paramsToString(Method m) {
        StringBuilder params = Arrays.stream(m.getParameterTypes()).map(x -> x.getSimpleName().replaceAll("\\[\\]", "Array")).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append);
        return params.toString();
    }

    private void checkMethod(Method m, ToCheck toCheck) {
        String msg = toCheck.value();
        msg = msg.isEmpty() ? m.getName() : msg;
        String testMethodName = String.format("p%06d000_checkMethod%s%s%s()", toCheck.priority(), this.C.getSimpleName(), m.getName(), this.paramsToString(m));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"%s\");\n", formatter, msg);
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Class<?> theClass = ReflectUtilities.parseType(\"%s\"); ", formatter, this.C.getName());
        this.f("        Method x = theClass.getDeclaredMethod(\"%s\"\n", formatter, m.getName());
        if (m.getParameterCount() > 0) {
            Class<?>[] tparam = m.getParameterTypes();
            this.f("          , ReflectUtilities.parseType(\"%s\")", formatter, tparam[0].getName());
            for (int i = 1; i < tparam.length; ++i) {
                this.f(",\n           ReflectUtilities.parseType(\"%s\")", formatter, tparam[i].getName());
            }
        }
        this.f("        );\n", formatter, new Object[0]);
        this.checkModifiers(msg, m.getModifiers(), toCheck.modifiers(), formatter);
        this.f("        assertTrue(\"Fix %s (Return)\", x.getReturnType().equals(ReflectUtilities.parseType(\"%s\")));\n", formatter, msg, m.getReturnType().getName());
        this.f("   } catch (NoSuchMethodException | SecurityException ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"Fix %s\");\n", formatter, msg);
        this.f("   } catch (ClassNotFoundException ex3) {\n", formatter, new Object[0]);
        this.f("        fail(\"Inexisting class \");\n", formatter, new Object[0]);
        this.f("   } catch (Exception ex2) {\n", formatter, new Object[0]);
        this.f("        fail(\"Unexpected Error \"+%s);\n", formatter, "ex2.toString()");
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
    }

    public void checkInnerClasses() {
        this.SB.append('\n');
        Arrays.stream(this.C.getDeclaredClasses()).filter(x -> x.getAnnotation(ToCheck.class) != null).forEach(c -> this.checkInnerClass((Class<?>)c, c.getAnnotation(ToCheck.class)));
    }

    private void checkInnerClass(Class<?> c, ToCheck toCheck) {
        String testMethodName = String.format("p%06d000_check%sInnerClass%s()", toCheck.priority(), this.C.getSimpleName(), this.initial(c.getSimpleName()));
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        this.f("\n@Test\n", formatter, new Object[0]);
        if (toCheck.grade() != Double.MIN_VALUE) {
            this.f("@caseine.format.javajunit.Grade(%f)\n", formatter, toCheck.grade());
        }
        this.f("public void %s {\n", formatter, testMethodName);
        this.f("   System.out.println(\"Check innerClass %s\");\n", formatter, c.getSimpleName());
        this.f("   try {\n", formatter, new Object[0]);
        this.f("        Class<?> x = ReflectUtilities.getDeclaredClass(%s.class, \"%s\");\n", formatter, this.C.getName(), c.getSimpleName());
        this.f("        if (x != null) {\n", formatter, new Object[0]);
        this.checkModifiers(toCheck.value(), c.getModifiers(), toCheck.modifiers(), formatter);
        this.f("        } else {\n", formatter, new Object[0]);
        this.f("           fail(\"Classe interne %s absente\");", formatter, c.getSimpleName());
        this.f("        }\n", formatter, new Object[0]);
        this.f("   } catch (Exception ex) {\n", formatter, new Object[0]);
        this.f("        fail(\"%s\");\n", formatter, toCheck.value());
        this.f("   }\n", formatter, new Object[0]);
        this.f("}\n", formatter, new Object[0]);
        this.put(testMethodName, sb);
        new Checker(c, this);
    }

    public String toString() {
        return this.SB.toString();
    }

    private String initial(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public String getAllTUOrderByName() {
        StringBuilder sb = new StringBuilder();
        this.MSBall.keySet().forEach(name -> sb.append((CharSequence)this.MSBall.get(name)));
        return sb.toString();
    }

    @Override
    public Iterator<BodyDeclaration<?>> iterator() {
        return new Iterator<BodyDeclaration<?>>(){
            private final Iterator<String> I;
            {
                this.I = Checker.this.BDall.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.I.hasNext();
            }

            @Override
            public BodyDeclaration<?> next() {
                return (BodyDeclaration)Checker.this.BDall.get(this.I.next());
            }
        };
    }
}

