/*
 * Decompiled with CFR 0.152.
 */
package caseine.publication;

import caseine.tags.ImplementationToRemove;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.ModifierVisitor;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import com.github.javaparser.utils.Pair;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ParserUtils {
    public static final double DEFAULT_MAXI_GRADE = 20.0;

    private static String getValueOf(NormalAnnotationExpr nae) {
        return ParserUtils.getValueOf((NodeList<MemberValuePair>)nae.getPairs());
    }

    private static String getValueOf(NodeList<MemberValuePair> pairs) {
        for (MemberValuePair mvp : pairs) {
            if (!"value".equals(mvp.getName().getIdentifier())) continue;
            return mvp.getValue().toString();
        }
        return "";
    }

    private static Comment toComment(String value) {
        if (value.contains("\n")) {
            return new BlockComment(" TODO " + value);
        }
        return new LineComment("TODO " + value);
    }

    private static Comment whatToDo(AnnotationExpr annotation) {
        Comment toDo = null;
        if (annotation.isSingleMemberAnnotationExpr()) {
            SingleMemberAnnotationExpr sma = annotation.asSingleMemberAnnotationExpr();
            String value = ParserUtils.toString(sma.getMemberValue());
            return ParserUtils.toComment(value);
        }
        if (annotation.isNormalAnnotationExpr()) {
            NormalAnnotationExpr na = annotation.asNormalAnnotationExpr();
            NodeList list = na.getPairs();
            String value = null;
            for (MemberValuePair mvp : list) {
                if (!"value".equals(mvp.getName().asString())) continue;
                value = mvp.getValue().toString();
            }
            if (value != null) {
                return ParserUtils.toComment(value);
            }
        }
        return toDo;
    }

    public static void importTagSuppression(CompilationUnit compilationUnit) {
        compilationUnit.getImports().removeIf(id -> id.getName().asString().startsWith("caseine.tags"));
    }

    public static void changePackageForCfTest(CompilationUnit compilationUnit) {
        Optional opt = compilationUnit.getPackageDeclaration();
        if (opt.isPresent()) {
            ((PackageDeclaration)opt.get()).setName("cf." + ((PackageDeclaration)opt.get()).getNameAsString());
        } else {
            compilationUnit.setPackageDeclaration("cf");
        }
    }

    public static String toString(Expression value) {
        if (value.isStringLiteralExpr()) {
            return value.asStringLiteralExpr().asString();
        }
        if (value.isBinaryExpr() && value.asBinaryExpr().getOperator() == BinaryExpr.Operator.PLUS) {
            return ParserUtils.toString(value.asBinaryExpr().getLeft()) + ParserUtils.toString(value.asBinaryExpr().getRight());
        }
        throw new IllegalArgumentException("Illegal annotation " + value);
    }

    public static void implementationSuppression(ClassOrInterfaceDeclaration cid) {
        Optional optA = cid.getAnnotationByClass(ImplementationToRemove.class);
        if (optA.isPresent()) {
            Set<String> implementation;
            AnnotationExpr annotationImplementationToRemove = (AnnotationExpr)optA.get();
            Expression value = annotationImplementationToRemove.isSingleMemberAnnotationExpr() ? annotationImplementationToRemove.asSingleMemberAnnotationExpr().getMemberValue() : ((MemberValuePair)annotationImplementationToRemove.asNormalAnnotationExpr().getPairs().get(0)).getValue();
            if (value.isStringLiteralExpr()) {
                implementation = new HashSet<String>();
                implementation.add(value.asStringLiteralExpr().asString());
            } else {
                implementation = value.asArrayInitializerExpr().getValues().stream().map(e -> e.asStringLiteralExpr().getValue()).collect(Collectors.toSet());
            }
            Set<Object> sci = new HashSet();
            sci = cid.isInterface() ? cid.asClassOrInterfaceDeclaration().getExtendedTypes().stream().filter(c -> c.isClassOrInterfaceType()).map(c -> c.asClassOrInterfaceType()).filter(c -> implementation.contains(c.getNameAsString())).collect(Collectors.toSet()) : cid.asClassOrInterfaceDeclaration().getImplementedTypes().stream().filter(c -> c.isClassOrInterfaceType()).map(c -> c.asClassOrInterfaceType()).filter(c -> implementation.contains(c.getNameAsString())).collect(Collectors.toSet());
            sci.stream().forEach(Node::remove);
        }
    }

    public static void implementationSuppression(CompilationUnit compilationUnit) {
        compilationUnit.getTypes().stream().filter(c -> c.isClassOrInterfaceDeclaration()).map(c -> c.asClassOrInterfaceDeclaration()).forEach(ParserUtils::implementationSuppression);
    }

    public static void toDoSuppression(CompilationUnit compilationUnit) {
        List toDoList = compilationUnit.stream().filter(n -> n instanceof AnnotationExpr).map(n -> (AnnotationExpr)n).filter(n -> n.getName().getIdentifier().endsWith("ToDo")).collect(Collectors.toList());
        toDoList.stream().forEach(n -> {
            n.getParentNode().ifPresent(p -> p.getParentNode().ifPresent(gp -> {
                Comment whatToDo = ParserUtils.whatToDo(n);
                if (whatToDo != null) {
                    try {
                        ClassOrInterfaceDeclaration nwa = (ClassOrInterfaceDeclaration)gp;
                        if (nwa.getAnnotationByName("ToDo").isPresent()) {
                            compilationUnit.addOrphanComment(whatToDo);
                            compilationUnit.addOrphanComment((Comment)new LineComment(""));
                        } else {
                            gp.addOrphanComment(whatToDo);
                            gp.addOrphanComment((Comment)new LineComment(""));
                        }
                    }
                    catch (Exception ex) {
                        gp.addOrphanComment(whatToDo);
                        gp.addOrphanComment((Comment)new LineComment(""));
                    }
                }
                n.getComment().ifPresent(c -> {
                    gp.addOrphanComment(c);
                    gp.addOrphanComment((Comment)new LineComment(""));
                });
                if (p instanceof NodeWithJavadoc) {
                    Optional jc = ((NodeWithJavadoc)p).getJavadocComment();
                    jc.ifPresent(c -> {
                        gp.addOrphanComment((Comment)c);
                        gp.addOrphanComment((Comment)new LineComment(""));
                    });
                }
            }));
            n.getParentNode().ifPresent(Node::remove);
        });
        List toDoInList = compilationUnit.stream().filter(n -> n instanceof AnnotationExpr).map(n -> (AnnotationExpr)n).filter(n -> n.getName().getIdentifier().endsWith("ToDoIn")).collect(Collectors.toList());
        toDoInList.stream().forEach(n -> n.getParentNode().ifPresent(p -> {
            if (p.getClass() == MethodDeclaration.class) {
                MethodDeclaration md = (MethodDeclaration)p;
                Type typeOfReturn = md.getType();
                String body = typeOfReturn.isVoidType() ? "{}" : (typeOfReturn.isReferenceType() ? "{return null;}" : (typeOfReturn.isArrayType() ? "{return null;}" : (typeOfReturn.asString().equals("boolean") ? "{return false;}" : "{return 0;}")));
                md = md.setBody(StaticJavaParser.parseBlock((String)body));
                Comment whatToDo = ParserUtils.whatToDo(n);
                md.getBody().ifPresent(b -> {
                    if (whatToDo == null) {
                        b.addOrphanComment((Comment)new LineComment("TODO"));
                    } else {
                        b.addOrphanComment(whatToDo);
                    }
                });
            }
        }));
    }

    public static void annotationSuppression(CompilationUnit compilationUnit) {
        ParserUtils.importTagSuppression(compilationUnit);
        ModifierVisitor mv = new NormalAnnotationSuppresser();
        mv.visit(compilationUnit, null);
        mv = new SingleMemberAnnotationSuppresser();
        mv.visit(compilationUnit, null);
        mv = new MarkerAnnotationSuppresser();
        mv.visit(compilationUnit, null);
    }

    public static Pair<Double, Double> getCounterAndMaxiGrade(CompilationUnit cu) {
        GradeCounter gc = new GradeCounter();
        gc.visit(cu, null);
        return gc.getCounterAndMaxiGrade();
    }

    public static void gradeTransforme(CompilationUnit cu, double cumul, double maximum) {
        GradeTransformer gc = new GradeTransformer(cumul, maximum);
        gc.visit(cu, null);
    }

    public static void gradeTransforme(CompilationUnit cu, double cumul) {
        ParserUtils.gradeTransforme(cu, cumul, 20.0);
    }

    public static void copyResources(Path src) throws IOException {
        Files.walk(src, new FileVisitOption[0]).filter(p -> !p.endsWith(".java")).forEach(System.out::println);
    }

    private static class GradeTransformer
    extends ModifierVisitor<Void> {
        private final double cumul;
        private final double maximum;

        public GradeTransformer(double cumul, double maximum) {
            this.cumul = cumul;
            this.maximum = maximum;
        }

        public Visitable visit(SingleMemberAnnotationExpr n, Void arg) {
            super.visit(n, (Object)arg);
            if ("Grade".equals(n.getNameAsString()) || "caseine.format.javajunit.Grade".equals(n.getNameAsString())) {
                double value;
                try {
                    value = Double.parseDouble(n.getMemberValue().toString());
                }
                catch (NumberFormatException ex) {
                    value = 0.0;
                }
                n.setMemberValue((Expression)new DoubleLiteralExpr(value * this.maximum / this.cumul));
            }
            return n;
        }
    }

    private static class GradeCounter
    extends VoidVisitorAdapter<Void> {
        private double counter = 0.0;
        private double maxiGrade = 0.0;

        private GradeCounter() {
        }

        public void visit(SingleMemberAnnotationExpr n, Void arg) {
            super.visit(n, (Object)arg);
            switch (n.getNameAsString()) {
                case "Grade": 
                case "caseine.format.javajunit.Grade": {
                    double value;
                    try {
                        value = Double.parseDouble(n.getMemberValue().toString());
                    }
                    catch (NumberFormatException ex) {
                        value = 0.0;
                    }
                    this.counter += value;
                    break;
                }
                case "RelativeEvaluation": 
                case "caseine.tags.RelativeEvaluation": {
                    try {
                        this.maxiGrade = Double.parseDouble(n.getMemberValue().toString());
                        break;
                    }
                    catch (NumberFormatException ex) {
                        this.maxiGrade = 20.0;
                    }
                }
            }
        }

        public void visit(MarkerAnnotationExpr n, Void arg) {
            super.visit(n, (Object)arg);
            switch (n.getNameAsString()) {
                case "RelativeEvaluation": 
                case "caseine.tags.RelativeEvaluation": {
                    this.maxiGrade = 20.0;
                }
            }
        }

        public void visit(NormalAnnotationExpr n, Void arg) {
            super.visit(n, (Object)arg);
            switch (n.getNameAsString()) {
                case "RelativeEvaluation": 
                case "caseine.tags.RelativeEvaluation": {
                    try {
                        this.maxiGrade = Double.parseDouble(ParserUtils.getValueOf(n));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        this.maxiGrade = 20.0;
                    }
                }
            }
        }

        public double getCounter() {
            return this.counter;
        }

        public double getMaxiGrade() {
            return this.maxiGrade;
        }

        public Pair<Double, Double> getCounterAndMaxiGrade() {
            return new Pair((Object)this.counter, (Object)this.maxiGrade);
        }
    }

    private static class SingleMemberAnnotationSuppresser
    extends ModifierVisitor<Void> {
        private SingleMemberAnnotationSuppresser() {
        }

        public SingleMemberAnnotationExpr visit(SingleMemberAnnotationExpr fd, Void arg) {
            super.visit(fd, (Object)arg);
            fd.remove();
            return null;
        }
    }

    private static class MarkerAnnotationSuppresser
    extends ModifierVisitor<Void> {
        private MarkerAnnotationSuppresser() {
        }

        public MarkerAnnotationExpr visit(MarkerAnnotationExpr fd, Void arg) {
            super.visit(fd, (Object)arg);
            fd.remove();
            return null;
        }
    }

    private static class NormalAnnotationSuppresser
    extends ModifierVisitor<Void> {
        private NormalAnnotationSuppresser() {
        }

        public NormalAnnotationExpr visit(NormalAnnotationExpr fd, Void arg) {
            super.visit(fd, (Object)arg);
            fd.remove();
            return null;
        }
    }
}

