/*
 * Decompiled with CFR 0.152.
 */
package caseine.publication;

import caseine.checker.Checker;
import caseine.publication.ParserUtils;
import caseine.publication.test.CompilationUnitTest;
import caseine.tags.ClassTestPriority;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.utils.Pair;
import com.github.javaparser.utils.SourceRoot;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Publisher
implements Iterable<String> {
    private final Path src;
    private final Path test;
    private final Path cfTarget;
    private final Path rfTarget;
    private final Path testTarget;
    private final Path testCfTarget;
    private final ClassLoader classLoader;
    private Set<String> classes;
    private Set<Path> pathsToRemove;
    private final Path resourcesSrc;
    private final Path resourcesTest;
    private static final String[] excludedFiles = new String[]{".DS_Store"};
    private final Set<PriorityTestClassName> ptcn = new TreeSet<PriorityTestClassName>();
    private final Path testTargetRF;
    private final Path testCfTargetRF;

    @Override
    public Iterator<String> iterator() {
        return new StringIterator();
    }

    public Publisher(Path src, Path test, Path target) throws IOException {
        this(src, test, null, null, target, target.getClass().getClassLoader());
    }

    public Publisher(Path src, Path test, Path resourcesSrc, Path resourcesTest, Path target, ClassLoader cl) {
        this.classLoader = cl;
        this.src = src;
        this.test = test;
        this.resourcesSrc = resourcesSrc;
        this.resourcesTest = resourcesTest;
        this.cfTarget = new File(target.toFile(), "cf").toPath();
        this.rfTarget = new File(target.toFile(), "rf").toPath();
        this.testTarget = new File(target.toFile(), "ef").toPath();
        this.testCfTarget = new File(this.testTarget.toFile(), "cf").toPath();
        this.pathsToRemove = new HashSet<Path>();
        this.classes = new HashSet<String>();
        this.testTargetRF = new File(target.toFile(), "testrf").toPath();
        this.testCfTargetRF = new File(this.testTargetRF.toFile(), "cf").toPath();
    }

    private void addPackage(CompilationUnit cu) {
        Optional optpd = cu.getPrimaryType();
        if (optpd.isPresent()) {
            this.classes.add((String)((TypeDeclaration)optpd.get()).getFullyQualifiedName().get());
        }
    }

    public void publishCf() throws IOException {
        SourceRoot sr = new SourceRoot(this.src);
        List prs = sr.tryToParse();
        if (prs.stream().allMatch(pr -> pr.isSuccessful())) {
            sr.getCompilationUnits().stream().peek(cu -> this.addPackage((CompilationUnit)cu)).forEach(ParserUtils::annotationSuppression);
            sr.saveAll(this.cfTarget);
        } else {
            prs.stream().filter(pr -> !pr.isSuccessful()).forEach(pr -> System.out.println("Probl\u00e8me " + pr.getResult().toString()));
        }
    }

    private boolean compilationUnitHasAPrimaryTypeAnnotedToBeRemoved(CompilationUnit cu) {
        Optional opttd = cu.getPrimaryType();
        if (opttd.isPresent()) {
            TypeDeclaration td = (TypeDeclaration)opttd.get();
            return td.isAnnotationPresent("FileToRemove");
        }
        return false;
    }

    private Path compilationUnitToPath(CompilationUnit cu) {
        String prefixe = "";
        Optional optpd = cu.getPackageDeclaration();
        if (optpd.isPresent()) {
            prefixe = ((PackageDeclaration)optpd.get()).getNameAsString().replaceAll("\\.", "/");
        }
        Path path = new File(prefixe, ((TypeDeclaration)cu.getPrimaryType().get()).getNameAsString() + ".java").toPath();
        return path;
    }

    public Set<Path> getPathToRemove() {
        return this.pathsToRemove;
    }

    public void publishRf() throws IOException {
        SourceRoot sr = new SourceRoot(this.src);
        List prs = sr.tryToParse();
        if (prs.stream().allMatch(pr -> pr.isSuccessful())) {
            this.pathsToRemove = sr.getCompilationUnits().stream().filter(cu -> this.compilationUnitHasAPrimaryTypeAnnotedToBeRemoved((CompilationUnit)cu)).map(cu -> this.compilationUnitToPath((CompilationUnit)cu)).collect(Collectors.toSet());
            sr.getCompilationUnits().stream().peek(ParserUtils::importTagSuppression).peek(ParserUtils::toDoSuppression).peek(ParserUtils::implementationSuppression).forEach(ParserUtils::annotationSuppression);
            sr.saveAll(this.rfTarget);
        } else {
            prs.stream().filter(pr -> !pr.isSuccessful()).forEach(pr -> System.out.println("Probl\u00e8me " + pr.getResult().toString()));
        }
        if (this.resourcesSrc != null && this.resourcesSrc.toFile().exists()) {
            this.copyFiles(this.resourcesSrc, this.rfTarget);
        }
    }

    private void putPTCN(CompilationUnit cu) {
        int priority = Integer.MAX_VALUE;
        String testClassName = "";
        Optional optpkg = cu.getPackageDeclaration();
        String prefixe = optpkg.isPresent() ? ((PackageDeclaration)optpkg.get()).getNameAsString() + "." : "";
        Optional opttd = cu.getPrimaryType();
        if (opttd.isPresent()) {
            AnnotationExpr ae;
            TypeDeclaration td = (TypeDeclaration)opttd.get();
            Optional optae = td.getAnnotationByName("ClassTestPriority");
            if (optae.isPresent() && (ae = (AnnotationExpr)optae.get()).isSingleMemberAnnotationExpr()) {
                ae = ae.asSingleMemberAnnotationExpr();
                priority = ae.asSingleMemberAnnotationExpr().getMemberValue().asIntegerLiteralExpr().asInt();
            }
            testClassName = ((TypeDeclaration)opttd.get()).getNameAsString();
        }
        if (!testClassName.isEmpty()) {
            this.ptcn.add(new PriorityTestClassName(priority, prefixe + testClassName));
        }
    }

    private void changeGradesIfRelativeGradesIsAsked() throws IOException {
        SourceRoot srctest = new SourceRoot(this.testTarget);
        srctest.tryToParse();
        Pair result = srctest.getCompilationUnits().stream().map(cu -> ParserUtils.getCounterAndMaxiGrade(cu)).reduce(new Pair((Object)0.0, (Object)0.0), (p1, p2) -> new Pair((Object)((Double)p1.a + (Double)p2.a), (Object)Double.max((Double)p1.b, (Double)p2.b)));
        double total = (Double)result.a;
        double maxi = (Double)result.b;
        if (maxi > 0.0) {
            srctest.getCompilationUnits().stream().forEach(cu -> ParserUtils.gradeTransforme(cu, total, maxi));
        }
        srctest.saveAll();
    }

    public void publishTest() throws IOException, ClassNotFoundException {
        Path path;
        CompilationUnitTest cut;
        String className;
        String packageName;
        Checker chk;
        SourceRoot srtest;
        List prs;
        if (!this.test.toFile().exists() || !this.test.toFile().isDirectory()) {
            this.test.toFile().mkdir();
        }
        if ((prs = (srtest = new SourceRoot(this.test)).tryToParse()).stream().allMatch(pr -> pr.isSuccessful())) {
            srtest.getCompilationUnits().stream().peek(cu -> this.putPTCN((CompilationUnit)cu)).forEach(ParserUtils::toDoSuppression);
            srtest.saveAll(this.testTarget);
            srtest.saveAll(this.testTargetRF);
        } else {
            prs.stream().filter(pr -> !pr.isSuccessful()).forEach(pr -> System.out.println("Probl\u00e8me " + pr.getResult().toString()));
        }
        for (Class<?> c : this.tryToGetAllClasses()) {
            chk = new Checker(c);
            packageName = "";
            if (c.getPackage() != null) {
                packageName = c.getPackage().getName();
            }
            className = "Generated" + c.getSimpleName() + "Test";
            cut = new CompilationUnitTest(className, packageName, "cf", chk);
            path = new File(this.testTarget.toFile(), packageName.replaceAll("\\.", "/") + "/" + className + ".java").toPath();
            cut.setStorage(path);
            srtest.add((CompilationUnit)cut);
            srtest.saveAll(this.testTarget);
            ClassTestPriority ctp = c.getAnnotation(ClassTestPriority.class);
            if (ctp == null) {
                this.ptcn.add(new PriorityTestClassName(packageName + "." + className));
                continue;
            }
            this.ptcn.add(new PriorityTestClassName(ctp.value(), packageName + "." + className));
        }
        for (Class<?> c : this.tryToGetAllClasses()) {
            chk = new Checker(c);
            packageName = "";
            if (c.getPackage() != null) {
                packageName = c.getPackage().getName();
            }
            className = "Generated" + c.getSimpleName() + "Test";
            cut = new CompilationUnitTest(className, packageName, "cf", chk);
            path = new File(this.testTargetRF.toFile(), packageName.replaceAll("\\.", "/") + "/" + className + ".java").toPath();
            cut.setStorage(path);
            srtest.add((CompilationUnit)cut);
            srtest.saveAll(this.testTargetRF);
        }
        if (this.resourcesTest != null && this.resourcesTest.toFile().exists()) {
            this.copyFiles(this.resourcesTest, this.testTarget);
        }
    }

    private void changeImportForCfTest(CompilationUnit cu) {
        block0: for (ImportDeclaration id : cu.getImports()) {
            String theImport = id.getNameAsString();
            if (!id.isAsterisk()) {
                theImport = theImport.replaceFirst(".[A-Z](.*)$", "");
            }
            for (String anImport : this.classes) {
                String ellicitedImport = anImport.replaceFirst(".[A-Z](.*)$", "");
                if (!ellicitedImport.equals(theImport)) continue;
                id.setName("\tcf." + id.getNameAsString());
                continue block0;
            }
        }
    }

    public void publishCfTest() throws IOException {
        SourceRoot sr = new SourceRoot(this.src);
        List prs = sr.tryToParse();
        if (prs.stream().allMatch(pr -> pr.isSuccessful())) {
            sr.getCompilationUnits().stream().peek(cu -> this.changeImportForCfTest((CompilationUnit)cu)).forEach(ParserUtils::changePackageForCfTest);
            sr.saveAll(this.testCfTarget);
        } else {
            prs.stream().filter(pr -> !pr.isSuccessful()).forEach(pr -> System.out.println("Probl\u00e8me " + pr.getResult().toString()));
        }
        sr = new SourceRoot(this.src);
        prs.clear();
        prs = sr.tryToParse();
        if (prs.stream().allMatch(pr -> pr.isSuccessful())) {
            sr.getCompilationUnits().stream().forEach(ParserUtils::changePackageForCfTest);
            sr.saveAll(this.testCfTargetRF);
        } else {
            prs.stream().filter(pr -> !pr.isSuccessful()).forEach(pr -> System.out.println("Probl\u00e8me " + pr.getResult().toString()));
        }
    }

    public void publishAll() throws IOException, ClassNotFoundException {
        this.publishCf();
        this.publishRf();
        this.publishTest();
        this.publishCfTest();
        this.changeGradesIfRelativeGradesIsAsked();
    }

    public List<Class<?>> tryToGetAllClasses() throws IOException, ClassNotFoundException {
        ArrayList allClasses = new ArrayList();
        SourceRoot sr = new SourceRoot(this.src);
        List cus = sr.tryToParse();
        for (ParseResult pr : cus) {
            String paquetage = "";
            if (!pr.isSuccessful() || !pr.getResult().isPresent()) continue;
            CompilationUnit cu = (CompilationUnit)pr.getResult().get();
            if (cu.getPackageDeclaration().isPresent()) {
                paquetage = ((PackageDeclaration)cu.getPackageDeclaration().get()).getNameAsString() + ".";
            }
            for (TypeDeclaration t : cu.getTypes()) {
                String classe = t.getNameAsString();
                allClasses.add(this.classLoader.loadClass(paquetage + classe));
            }
        }
        return allClasses;
    }

    private void copyFiles(final Path sourceParentFolder, final Path destinationParentFolder) {
        try (Stream<Path> allFilesPathStream2 = Files.walk(sourceParentFolder, new FileVisitOption[0]);){
            Consumer<Path> action = new Consumer<Path>(){

                @Override
                public void accept(Path t) {
                    try {
                        String destinationPath = t.toString().replaceAll(sourceParentFolder.toString(), destinationParentFolder.toString());
                        for (int i = 0; i < excludedFiles.length; ++i) {
                            if (!t.endsWith(excludedFiles[i])) continue;
                            return;
                        }
                        Files.copy(t, Paths.get(destinationPath, new String[0]), new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
            allFilesPathStream2.forEach(action);
        }
        catch (FileAlreadyExistsException allFilesPathStream2) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class StringIterator
    implements Iterator<String> {
        private Iterator<PriorityTestClassName> it;

        private StringIterator() {
            this.it = Publisher.this.ptcn.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public String next() {
            return this.it.next().toString();
        }
    }

    private static final class PriorityTestClassName
    implements Comparable<PriorityTestClassName> {
        public final int priority;
        public final String className;

        public PriorityTestClassName(String className) {
            this(Integer.MAX_VALUE, className);
        }

        public PriorityTestClassName(int priority, String className) {
            this.priority = priority;
            this.className = className;
        }

        @Override
        public int compareTo(PriorityTestClassName o) {
            if (this.priority < o.priority) {
                return -1;
            }
            if (this.priority > o.priority) {
                return 1;
            }
            return this.className.compareTo(o.className);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + this.priority;
            hash = 97 * hash + Objects.hashCode(this.className);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PriorityTestClassName other = (PriorityTestClassName)obj;
            if (this.priority != other.priority) {
                return false;
            }
            return Objects.equals(this.className, other.className);
        }

        public String toString() {
            return this.className;
        }
    }
}

