/*
 * Decompiled with CFR 0.152.
 */
package caseine.reflect;

import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.lang.reflect.Method;
import java.util.Arrays;

public class CloneChecker<C> {
    private final Class<C> checkedClass;
    private final BlockStmt bodyToCheck;
    private boolean cloneDeclared;
    private boolean interfaceCloneableImplemented;
    private boolean returnsC;
    private boolean notThrowCloneNotSupportedException;
    private boolean notUseNew;
    private Method clone;

    public CloneChecker(Class<C> classToCheck, BlockStmt bodyToCheck) {
        this.checkedClass = classToCheck;
        this.bodyToCheck = bodyToCheck;
        this.cloneDeclared = false;
        this.interfaceCloneableImplemented = false;
        this.returnsC = false;
        this.notThrowCloneNotSupportedException = false;
        this.notUseNew = false;
        this.clone = null;
        this.check();
    }

    public CloneChecker(Class<C> classToCheck) {
        this(classToCheck, null);
    }

    private <T> void check() {
        try {
            this.clone = this.checkedClass.getDeclaredMethod("clone", new Class[0]);
            this.cloneDeclared = true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            this.cloneDeclared = false;
        }
        try {
            this.interfaceCloneableImplemented = Arrays.stream(this.checkedClass.getInterfaces()).anyMatch(c -> c == Cloneable.class);
        }
        catch (SecurityException ex) {
            this.interfaceCloneableImplemented = false;
        }
        if (this.cloneDeclared) {
            this.returnsC = this.clone.getReturnType() == this.checkedClass;
            boolean bl = this.notThrowCloneNotSupportedException = !Arrays.stream(this.clone.getExceptionTypes()).anyMatch(c -> c == CloneNotSupportedException.class);
            if (this.bodyToCheck != null) {
                CloneVisitor cloneVisitor = new CloneVisitor();
                this.bodyToCheck.accept((VoidVisitor)cloneVisitor, null);
                this.notUseNew = cloneVisitor.useNew == false;
            } else {
                this.notUseNew = true;
            }
        }
    }

    public Class<C> getCheckedClass() {
        return this.checkedClass;
    }

    public BlockStmt getBodyToCheck() {
        return this.bodyToCheck;
    }

    public boolean isCloneDeclared() {
        return this.cloneDeclared;
    }

    public boolean isInterfaceCloneableImplemented() {
        return this.interfaceCloneableImplemented;
    }

    public boolean isReturnsC() {
        return this.returnsC;
    }

    public boolean isNotThrowCloneNotSupportedException() {
        return this.notThrowCloneNotSupportedException;
    }

    public boolean isNotUseNew() {
        return this.notUseNew;
    }

    public Method getClone() {
        return this.clone;
    }

    private static class CloneVisitor
    extends VoidVisitorAdapter<Void> {
        private Boolean useNew = false;

        private CloneVisitor() {
        }

        public void visit(ObjectCreationExpr n, Void v) {
            super.visit(n, (Object)v);
            this.useNew = !n.getTypeAsString().contains("Exception");
        }
    }
}

