/*
 * Decompiled with CFR 0.152.
 */
package caseine.reflect;

import caseine.reflect.ReflectUtilities;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EqualChecker<C> {
    private final Class<C> checkedClass;
    private final BlockStmt bodyToCheck;
    private boolean equalsDeclared;
    private boolean hashcodeDeclared;
    private boolean ableToInstantiate;
    private boolean notEqualToNull;
    private boolean equalToItSelf;
    private boolean notUseInstanceOf;
    private Method equals;

    public EqualChecker(Class<C> classToCheck, BlockStmt bodyToCheck) {
        this.checkedClass = classToCheck;
        this.bodyToCheck = bodyToCheck;
        this.equalsDeclared = false;
        this.hashcodeDeclared = false;
        this.ableToInstantiate = false;
        this.notEqualToNull = false;
        this.equalToItSelf = false;
        this.notUseInstanceOf = true;
        this.equals = null;
        this.check();
    }

    public EqualChecker(Class<C> classToCheck) {
        this(classToCheck, null);
    }

    private <C> void check() {
        try {
            this.equals = this.checkedClass.getDeclaredMethod("equals", Object.class);
            this.equalsDeclared = true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            this.equalsDeclared = false;
        }
        try {
            this.checkedClass.getDeclaredMethod("hashCode", new Class[0]);
            this.hashcodeDeclared = true;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            this.hashcodeDeclared = false;
        }
        if (this.equalsDeclared) {
            Object obj = null;
            try {
                obj = ReflectUtilities.randomValue(this.checkedClass);
                this.ableToInstantiate = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                this.ableToInstantiate = false;
            }
            if (obj != null) {
                try {
                    this.notEqualToNull = (Boolean)this.equals.invoke(obj, new Object[]{null}) == false;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    this.notEqualToNull = false;
                }
                try {
                    this.equalToItSelf = (Boolean)this.equals.invoke(obj, obj);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    this.equalToItSelf = false;
                }
            }
            if (this.bodyToCheck != null) {
                EqualsVisitor equalsVisitor = new EqualsVisitor();
                this.bodyToCheck.accept((VoidVisitor)equalsVisitor, null);
                this.notUseInstanceOf = equalsVisitor.notUseInstanceOf;
            } else {
                this.notUseInstanceOf = true;
            }
        }
    }

    public Class<C> getCheckedClass() {
        return this.checkedClass;
    }

    public boolean isEqualsDeclared() {
        return this.equalsDeclared;
    }

    public boolean isHashcodeDeclared() {
        return this.hashcodeDeclared;
    }

    public boolean isAbleToInstantiate() {
        return this.ableToInstantiate;
    }

    public boolean isNotEqualToNull() {
        return this.notEqualToNull;
    }

    public boolean isEqualToItSelf() {
        return this.equalToItSelf;
    }

    public Method getEquals() {
        return this.equals;
    }

    public BlockStmt getBodyToCheck() {
        return this.bodyToCheck;
    }

    public boolean isNotUseInstanceOf() {
        return this.notUseInstanceOf;
    }

    private static class EqualsVisitor
    extends VoidVisitorAdapter<Void> {
        private Boolean notUseInstanceOf = true;

        private EqualsVisitor() {
        }

        public void visit(InstanceOfExpr n, Void v) {
            super.visit(n, (Object)v);
            this.notUseInstanceOf = false;
        }
    }
}

