/*
 * Decompiled with CFR 0.152.
 */
package caseine.reflect;

import caseine.exceptions.NoSimpleConstructor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;

public class ReflectUtilities {
    private static Random R = new Random();

    public static <T> T getTA(Class<T> c, Object ... pv) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] params = new Class[pv.length / 2];
        Object[] values = new Object[pv.length / 2];
        int j = 0;
        for (int i = 0; i < pv.length; i += 2) {
            params[j] = (Class)pv[i];
            values[j++] = pv[i + 1];
        }
        Constructor<T> k = c.getDeclaredConstructor(params);
        return k.newInstance(values);
    }

    public static <T> T get(Class<T> c, Object ... pv) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] coupletv = new Object[2 * pv.length];
        int k = 0;
        for (int i = 0; i < pv.length; ++i) {
            if (pv[i] != null) {
                coupletv[k++] = pv[i].getClass();
                coupletv[k++] = pv[i];
                continue;
            }
            coupletv[k++] = Object.class;
            coupletv[k++] = null;
        }
        return ReflectUtilities.getTA(c, coupletv);
    }

    public static Object getFromMethodTA(Class<?> c, Object o, String methodName, Object ... pv) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        StringBuilder methodNameAndArgs = new StringBuilder(methodName);
        methodNameAndArgs.append("(");
        Class[] params = new Class[pv.length / 2];
        Object[] values = new Object[pv.length / 2];
        int k = 0;
        for (int i = 0; i < pv.length; i += 2) {
            params[k] = (Class)pv[i];
            methodNameAndArgs.append(params[k].getSimpleName()).append(", ");
            values[k++] = pv[i + 1];
        }
        methodNameAndArgs.append(")");
        Method method = c.getDeclaredMethod(methodName, params);
        method.setAccessible(true);
        if (Modifier.isStatic(method.getModifiers())) {
            return method.invoke(null, values);
        }
        return method.invoke(o, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFromMethodTASystemOut(Class<?> c, Object o, String methodName, Object ... pv) throws FileNotFoundException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        PrintStream out = System.out;
        try {
            String string;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                System.setOut(new PrintStream(bos));
                ReflectUtilities.getFromMethodTA(c, o, methodName, pv);
                string = bos.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException ex) {
                    String string2 = "";
                    return string2;
                }
            }
            bos.close();
            return string;
        }
        finally {
            System.setOut(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFromMethodTASystemInOut(Class<?> c, Object o, String methodName, String sin, Object ... pv) throws FileNotFoundException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        PrintStream out = System.out;
        InputStream in = System.in;
        try {
            String string;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                System.setOut(new PrintStream(bos));
                System.setIn(new ByteArrayInputStream(sin.getBytes()));
                ReflectUtilities.getFromMethodTA(c, o, methodName, pv);
                string = bos.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException ex) {
                    String string2 = "";
                    return string2;
                }
            }
            bos.close();
            return string;
        }
        finally {
            System.setOut(out);
            System.setIn(in);
        }
    }

    public static Object getFromMethod(Class<?> c, Object o, String methodName, Object ... pv) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] coupletv = new Object[2 * pv.length];
        int k = 0;
        for (int i = 0; i < pv.length; ++i) {
            if (pv[i] != null) {
                coupletv[k++] = pv[i].getClass();
                coupletv[k++] = pv[i];
                continue;
            }
            coupletv[k++] = Object.class;
            coupletv[k++] = null;
        }
        return ReflectUtilities.getFromMethodTA(c, o, methodName, coupletv);
    }

    public static void setAttribut(Class<?> c, Object o, String nom, Object v) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fnom = c.getDeclaredField(nom);
        fnom.setAccessible(true);
        fnom.set(o, v);
    }

    public static Object getAttribut(Class<?> c, Object o, String nom) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field fnom = c.getDeclaredField(nom);
        fnom.setAccessible(true);
        return fnom.get(o);
    }

    public static boolean checkIfMutable(Object o1, Method m) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, FileNotFoundException {
        Object o2 = ReflectUtilities.clone(o1);
        m.setAccessible(true);
        for (int i = 0; i < 100; ++i) {
            PrintStream out = System.out;
            PrintStream err = System.err;
            System.setOut(new PrintStream("tmpout"));
            System.setErr(new PrintStream("tmperr"));
            m.setAccessible(true);
            m.invoke(o2, ReflectUtilities.fillParametersArray(m));
            System.setOut(out);
            System.setErr(err);
            if (ReflectUtilities.equals(o1, o2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isASetter(Method m, Class<?> C2) {
        try {
            Constructor<?> c = C2.getConstructor(new Class[0]);
            c.setAccessible(true);
            Object obj = c.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean thereIsSetter(Class<?> C2) {
        return Arrays.stream(C2.getMethods()).anyMatch(m -> m.getName().startsWith("set")) || Arrays.stream(C2.getDeclaredMethods()).filter(m -> !Modifier.isPrivate(m.getModifiers())).anyMatch(m -> m.getName().startsWith("set"));
    }

    public static boolean isMutable(Class<?> C2) {
        return ReflectUtilities.thereIsSetter(C2) || Arrays.stream(C2.getDeclaredFields()).anyMatch(p -> !Modifier.isPrivate(p.getModifiers()) && (!Modifier.isFinal(p.getModifiers()) || !p.getType().isPrimitive() && ReflectUtilities.isMutable(p.getType()))) || Arrays.stream(C2.getFields()).anyMatch(p -> !Modifier.isPrivate(p.getModifiers()) && (!Modifier.isFinal(p.getModifiers()) || !p.getType().isPrimitive() && ReflectUtilities.isMutable(p.getType())));
    }

    public static boolean checkAttributsForMutability(Class<?> c) {
        return Arrays.stream(c.getDeclaredFields()).anyMatch(p -> !Modifier.isPrivate(p.getModifiers()) && (!Modifier.isFinal(p.getModifiers()) || !p.getType().isPrimitive() && ReflectUtilities.isMutable(p.getType()))) || Arrays.stream(c.getFields()).anyMatch(p -> !Modifier.isPrivate(p.getModifiers()) && (!Modifier.isFinal(p.getModifiers()) || !p.getType().isPrimitive() && ReflectUtilities.isMutable(p.getType())));
    }

    public static boolean checkIfMutable(Class<?> c) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, FileNotFoundException {
        Object o1 = ReflectUtilities.randomValue(c);
        for (Method m : c.getDeclaredMethods()) {
            if (Modifier.isStatic(m.getModifiers()) || !ReflectUtilities.checkIfMutable(o1, m)) continue;
            return true;
        }
        return false;
    }

    public static Object clone(Object o1, Class<?> c2) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, NoSuchFieldException {
        Object o2 = ReflectUtilities.randomValue(c2);
        for (Field f1 : o1.getClass().getDeclaredFields()) {
            f1.setAccessible(true);
            Field f2 = c2.getDeclaredField(f1.getName());
            f1.setAccessible(true);
            f2.setAccessible(true);
            if (f2.getType() == f1.getType()) {
                f2.set(o2, f1.get(o1));
                continue;
            }
            f2.set(o2, ReflectUtilities.clone(f1.get(o1), f2.getType()));
        }
        return o2;
    }

    public static Object clone(Object o) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Object co = ReflectUtilities.randomValue(o.getClass());
        for (Field f : o.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            f.set(co, f.get(o));
        }
        return co;
    }

    public static boolean equals(Object o1, Object o2) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return ReflectUtilities.equals(o1, o2, false);
    }

    public static boolean equals(Object o1, Object o2, boolean isPrimitive) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        boolean hasEqualsMethod = false;
        try {
            o1.getClass().getDeclaredMethod("equals", Object.class);
            hasEqualsMethod = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!o1.getClass().getSimpleName().equals(o2.getClass().getSimpleName())) {
            return false;
        }
        if (o1.getClass() == o2.getClass() && hasEqualsMethod) {
            return o1.equals(o2);
        }
        if (o1.getClass().isPrimitive() || isPrimitive) {
            return o1.equals(o2);
        }
        for (Field f1 : o1.getClass().getDeclaredFields()) {
            try {
                f1.setAccessible(true);
                Field f2 = o2.getClass().getDeclaredField(f1.getName());
                if (Modifier.isStatic(f1.getModifiers())) continue;
                f1.setAccessible(true);
                f2.setAccessible(true);
                if (ReflectUtilities.equals(f1.get(o1), f2.get(o2), f1.getType().isPrimitive())) continue;
                return false;
            }
            catch (NoSuchFieldException | SecurityException ex) {
                return false;
            }
        }
        return true;
    }

    public static boolean allParametersArePrimitive(Constructor<?> c) {
        return Arrays.stream(c.getParameterTypes()).allMatch(p -> p.isPrimitive());
    }

    public static Constructor<?> getOneConstructor(Class<?> c) {
        Optional<Constructor> optK = Arrays.stream(c.getDeclaredConstructors()).filter(p -> p.getParameterCount() > 0).findFirst();
        if (optK.isPresent()) {
            return optK.get();
        }
        optK = Arrays.stream(c.getConstructors()).filter(p -> p.getParameterCount() > 0).findFirst();
        if (optK.isPresent()) {
            optK.get().setAccessible(true);
            return optK.get();
        }
        return null;
    }

    public static Constructor<?> getOneSimpleConstructor(Class<?> c) throws NoSimpleConstructor {
        Optional<Constructor> optK = Arrays.stream(c.getDeclaredConstructors()).filter(p -> p.getParameterCount() > 0).filter(p -> ReflectUtilities.allParametersArePrimitive(p)).findFirst();
        if (optK.isPresent()) {
            return optK.get();
        }
        optK = Arrays.stream(c.getConstructors()).filter(p -> ReflectUtilities.allParametersArePrimitive(p)).findFirst();
        if (optK.isPresent()) {
            optK.get().setAccessible(true);
            return optK.get();
        }
        throw new NoSimpleConstructor();
    }

    public static Object[] fillParametersArray(Executable k) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Object[] values = (Object[])Array.newInstance(Object.class, k.getParameterCount());
        Class<?>[] paramtypes = k.getParameterTypes();
        for (int i = 0; i < values.length; ++i) {
            if (paramtypes[i] == Character.TYPE) {
                values[i] = Character.valueOf((char)R.nextInt());
                continue;
            }
            Array.set(values, i, ReflectUtilities.randomValue(paramtypes[i]));
        }
        return values;
    }

    public static int randomInt(int min, int max, boolean notNul) {
        int r = min + R.nextInt(max - min + 1);
        if (notNul) {
            while (r == 0) {
                r = min + R.nextInt(max - min + 1);
            }
        }
        return r;
    }

    public static int randomInt(int min, int max) {
        return ReflectUtilities.randomInt(min, max, false);
    }

    public static Object randomValue(Class<?> c, Object ... p) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] type = new Class[p.length];
        for (int i = 0; i < p.length; ++i) {
            type[i] = p[i].getClass();
        }
        Constructor<?> k = c.getConstructor(type);
        k.setAccessible(true);
        return k.newInstance(p);
    }

    public static Object randomValue(Class<?> c, Class<?> ... p) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (p.length == 0) {
            Constructor<?> k = c.getConstructor(p);
            k.setAccessible(true);
            Object o = k.newInstance(ReflectUtilities.fillParametersArray(k));
            return o;
        }
        return ReflectUtilities.randomValue(c);
    }

    private static String randomString() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        int n = ReflectUtilities.randomInt(0, 10);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(ReflectUtilities.randomValue(Character.TYPE));
        }
        return sb.toString();
    }

    public static Object randomValue(Class<?> c) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        Constructor<?> k;
        if (c == Void.TYPE) {
            return null;
        }
        if (c == Boolean.TYPE) {
            return R.nextBoolean();
        }
        if (c == Integer.TYPE || c == Byte.TYPE) {
            return 50 - R.nextInt(101);
        }
        if (c == Character.TYPE) {
            return Character.valueOf((char)(65 + R.nextInt(26)));
        }
        if (c == Long.TYPE) {
            return R.nextLong();
        }
        if (c == Double.TYPE) {
            return R.nextDouble();
        }
        if (c == Float.TYPE) {
            return Float.valueOf(R.nextFloat());
        }
        if (c == String.class) {
            return ReflectUtilities.randomString();
        }
        if (c.isArray()) {
            return Array.newInstance(c.getComponentType(), 0);
        }
        try {
            k = c.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex1) {
            try {
                k = c.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException ex2) {
                try {
                    k = ReflectUtilities.getOneSimpleConstructor(c);
                }
                catch (NoSimpleConstructor ex) {
                    k = ReflectUtilities.getOneConstructor(c);
                }
            }
        }
        if (k != null) {
            k.setAccessible(true);
            Object o = k.newInstance(ReflectUtilities.fillParametersArray(k));
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                f.setAccessible(true);
                f.set(o, ReflectUtilities.randomValue(f.getType()));
            }
            return o;
        }
        return null;
    }

    public static boolean isCheckedException(Class<?> crt) {
        while (crt != Object.class) {
            if (crt == RuntimeException.class) {
                return false;
            }
            if (crt == Exception.class) {
                return true;
            }
            crt = crt.getSuperclass();
        }
        return false;
    }

    public static boolean isCheckedException(Throwable cause) {
        for (Class<?> crt = cause.getClass(); crt != Throwable.class; crt = crt.getSuperclass()) {
            if (crt != RuntimeException.class) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean sameResult(StringBuilder msg, Class<?> c1, Class<?> c2, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        Object o1;
        Object o2;
        Method m1 = c1.getDeclaredMethod(methodName, parameterTypes);
        Method m2 = c2.getDeclaredMethod(methodName, parameterTypes);
        m1.setAccessible(true);
        m2.setAccessible(true);
        if (Modifier.isStatic(m1.getModifiers())) {
            if (!Modifier.isStatic(m2.getModifiers())) return false;
            o2 = null;
            o1 = null;
        } else {
            if (Modifier.isStatic(m2.getModifiers())) return false;
            o1 = ReflectUtilities.randomValue(c1);
            o2 = ReflectUtilities.clone(o1, c2);
        }
        Object[] param = new Object[parameterTypes.length];
        for (int i = 0; i < param.length; ++i) {
            param[i] = ReflectUtilities.randomValue(parameterTypes[i]);
        }
        m1.setAccessible(true);
        m2.setAccessible(true);
        Object r1 = null;
        Object r2 = null;
        try {
            r1 = m1.invoke(o1, param);
            r2 = m2.invoke(o2, param);
        }
        catch (InvocationTargetException ex) {
            try {
                r2 = m2.invoke(o2, param);
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        msg.append(r1).append(" <> ").append(r2);
        if (r1 == null) {
            if (r2 != null) return false;
            return true;
        }
        if (r2 != null) return ReflectUtilities.equals(r1, r2);
        return false;
    }

    public static Class<?> parseType(String className) throws ClassNotFoundException {
        switch (className) {
            case "boolean": {
                return Boolean.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        String fqn = className.contains(".") ? className : "java.lang.".concat(className);
        return Class.forName(fqn);
    }

    public static Class<?> getDeclaredClass(Class<?> c, String name) {
        Optional<Class> optic = Arrays.stream(c.getDeclaredClasses()).filter(ic -> ic.getSimpleName().equals(name)).findFirst();
        if (optic.isPresent()) {
            return optic.get();
        }
        return null;
    }

    static class B {
        double x;

        B() {
        }
    }

    static class A {
        double x;

        A() {
        }
    }
}

