/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.catools.common.collections.interfaces.CCollection;
import org.catools.common.text.CStringUtil;

public class CList<E>
extends ArrayList<E>
implements CCollection<E>,
List<E> {
    public CList() {
    }

    public CList(E ... c) {
        if (c != null && c.length > 0) {
            Arrays.asList(c).forEach((? super T n) -> this.add(n));
        }
    }

    public CList(Stream<E> stream) {
        stream.forEach((? super T n) -> this.add(n));
    }

    public CList(Iterable<E> iterable) {
        if (iterable != null) {
            iterable.forEach((? super T n) -> this.add(n));
        }
    }

    @Override
    public CCollection<E> getBaseValue() {
        return this;
    }

    public int indexOf(Predicate<E> predicate) {
        Optional first = this.getBaseValue().stream().filter(predicate).findFirst();
        return first.isPresent() ? this.indexOf(first.get()) : -1;
    }

    public String join(int fromIndex, int toIndex) {
        return this.join(fromIndex, toIndex, "");
    }

    public String join(int fromIndex, int toIndex, String separator) {
        return CStringUtil.join(this.subList(fromIndex, toIndex), (String)separator);
    }

    public CList<E> set(Collection<? extends E> items) {
        super.clear();
        super.addAll(items);
        return this;
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    @Override
    public String toString() {
        return this.join(", ");
    }
}

