/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.catools.common.collections.interfaces.CCollection;

public class CSet<E>
extends HashSet<E>
implements CCollection<E>,
Set<E> {
    public CSet() {
    }

    public CSet(E ... c) {
        if (c != null && c.length > 0) {
            Arrays.asList(c).forEach((? super T n) -> this.add(n));
        }
    }

    public CSet(Stream<E> stream) {
        stream.forEach((? super T n) -> super.add(n));
    }

    public CSet(Iterable<E> iterable) {
        if (iterable != null) {
            iterable.forEach((? super T n) -> this.add(n));
        }
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public boolean equals(Object c) {
        return c != null && c instanceof Collection && ((Collection)c).size() == this.size() && this.containsAll((Collection)c) && ((Collection)c).containsAll(this);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        super.forEach(action);
    }

    @Override
    public CCollection<E> getBaseValue() {
        return this;
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return super.removeIf(filter);
    }

    public CSet<E> set(Collection<? extends E> items) {
        super.clear();
        super.addAll(items);
        return this;
    }

    @Override
    public Stream<E> stream() {
        return super.stream();
    }

    @Override
    public String toString() {
        return this.join(", ");
    }
}

