/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.collections.interfaces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.collections.interfaces.CIterable;
import org.catools.common.extensions.types.interfaces.CCollectionExtension;
import org.catools.common.text.CStringUtil;
import org.catools.common.utils.CRandomUtil;

public interface CCollection<E>
extends CIterable<E>,
Collection<E>,
CCollectionExtension<E> {
    @Override
    public boolean add(E var1);

    @Override
    public boolean addAll(Collection<? extends E> var1);

    default public boolean addIf(Predicate<E> predicate, E e) {
        return predicate.test(e) ? this.getBaseValue().add(e) : false;
    }

    @Override
    public void clear();

    @Override
    public boolean contains(Object var1);

    @Override
    public boolean containsAll(Collection<?> var1);

    @Override
    public boolean equals(Object var1);

    @Override
    public void forEach(Consumer<? super E> var1);

    @Override
    default public CList<E> getAll(Predicate<E> predicate) {
        return new CList((Iterable)this.getBaseValue().stream().filter(predicate).collect(Collectors.toList()));
    }

    @Override
    default public E getAny() {
        if (this.isEmpty()) {
            return null;
        }
        Object[] objects = this.getBaseValue().toArray();
        return (E)objects[CRandomUtil.Int.getNext(0, objects.length)];
    }

    default public E getAnyAndRemove() {
        if (this.isEmpty()) {
            return null;
        }
        Object[] objects = this.getBaseValue().toArray();
        Object object = objects[CRandomUtil.Int.getNext(0, objects.length)];
        this.remove(object);
        return (E)object;
    }

    @Override
    default public E getFirst() {
        return this.getBaseValue().stream().findFirst().get();
    }

    @Override
    default public E getFirst(Predicate<E> predicate) {
        return this.getBaseValue().stream().filter(predicate).findFirst().get();
    }

    @Override
    default public E getFirstOrElse(E other) {
        return this.getBaseValue().stream().findFirst().orElse(other);
    }

    @Override
    default public E getFirstOrElse(Predicate<E> predicate, E other) {
        return this.getBaseValue().stream().filter(predicate).findFirst().orElse(other);
    }

    @Override
    default public E getFirstOrNull() {
        return this.getFirstOrElse(null);
    }

    @Override
    default public E getFirstOrNull(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null);
    }

    @Override
    default public E getFirstOrThrow(RuntimeException e) {
        return this.getBaseValue().stream().findFirst().orElseThrow(() -> e);
    }

    @Override
    default public E getFirstOrThrow(Predicate<E> predicate, RuntimeException e) {
        return this.getBaseValue().stream().filter(predicate).findFirst().orElseThrow(() -> e);
    }

    @Override
    public CCollection<E> getBaseValue();

    @Override
    default public boolean has(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null) != null;
    }

    @Override
    default public boolean hasNot(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null) == null;
    }

    @Override
    public boolean isEmpty();

    @Override
    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Iterator<E> iterator();

    @Override
    default public String join() {
        return this.join("");
    }

    @Override
    default public String join(String separator) {
        return CStringUtil.join((Iterable)this.getBaseValue(), (String)separator);
    }

    @Override
    default public String join(Function<? super E, ? extends String> mapper, String separator) {
        return CStringUtil.join(this.mapToList(mapper), (String)separator);
    }

    @Override
    default public <R> Stream<R> map(Function<? super E, ? extends R> mapper) {
        return this.stream().map(mapper);
    }

    @Override
    default public <R> CList<R> mapToList(Function<? super E, ? extends R> mapper) {
        return new CList((Iterable)this.map(mapper).collect(Collectors.toList()));
    }

    @Override
    default public <R> CSet<R> mapToSet(Function<? super E, ? extends R> mapper) {
        return new CSet((Iterable)this.map(mapper).collect(Collectors.toList()));
    }

    default public CList<CList<E>> partition(int size) {
        return new CList<CList<E>>(Lists.partition(new ArrayList(this.getBaseValue()), (int)size).stream().map((? super T n) -> new CList(n)).collect(Collectors.toList()));
    }

    @Override
    public boolean remove(Object var1);

    @Override
    public boolean removeAll(Collection<?> var1);

    @Override
    public boolean removeIf(Predicate<? super E> var1);

    @Override
    public boolean retainAll(Collection<?> var1);

    @Override
    public int size();

    @Override
    public Spliterator<E> spliterator();

    @Override
    public Stream<E> stream();

    @Override
    public Object[] toArray();

    @Override
    public <E1> E1[] toArray(E1[] var1);

    @Override
    default public CList<E> toList() {
        return new CList(this.getBaseValue());
    }

    @Override
    default public CSet<E> toSet() {
        return new CSet(this.getBaseValue());
    }
}

