/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.collections.interfaces;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.extensions.types.interfaces.CIterableExtension;
import org.catools.common.text.CStringUtil;
import org.catools.common.utils.CRandomUtil;

public interface CIterable<E>
extends Iterable<E>,
CIterableExtension<E> {
    public boolean equals(Object var1);

    @Override
    default public void forEach(Consumer<? super E> action) {
        ((Iterable)this.getBaseValue()).forEach(action);
    }

    default public CList<E> getAll(Predicate<E> predicate) {
        return new CList((Iterable)this.stream().filter(predicate).collect(Collectors.toList()));
    }

    default public E getAny() {
        if (this.isEmpty()) {
            return null;
        }
        Object[] objects = this.stream().toArray();
        return (E)objects[CRandomUtil.Int.getNext(0, objects.length)];
    }

    default public E getFirst() {
        return this.stream().findFirst().get();
    }

    default public E getFirst(Predicate<E> predicate) {
        return this.stream().filter(predicate).findFirst().get();
    }

    default public E getFirstOrElse(E other) {
        return this.stream().findFirst().orElse(other);
    }

    default public E getFirstOrElse(Predicate<E> predicate, E other) {
        return this.stream().filter(predicate).findFirst().orElse(other);
    }

    default public E getFirstOrNull() {
        return this.getFirstOrElse(null);
    }

    default public E getFirstOrNull(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null);
    }

    default public E getFirstOrThrow(RuntimeException e) {
        return this.stream().findFirst().orElseThrow(() -> e);
    }

    default public E getFirstOrThrow(Predicate<E> predicate, RuntimeException e) {
        return this.stream().filter(predicate).findFirst().orElseThrow(() -> e);
    }

    @Override
    default public boolean has(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null) != null;
    }

    @Override
    default public boolean hasNot(Predicate<E> predicate) {
        return this.getFirstOrElse(predicate, null) == null;
    }

    @Override
    public Iterator<E> iterator();

    default public String join() {
        return this.join("");
    }

    default public String join(String separator) {
        return CStringUtil.join((Iterable)((Iterable)this.getBaseValue()), (String)separator);
    }

    default public String join(Function<? super E, ? extends String> mapper, String separator) {
        return CStringUtil.join(this.mapToList(mapper), (String)separator);
    }

    default public <R> Stream<R> map(Function<? super E, ? extends R> mapper) {
        return this.stream().map(mapper);
    }

    default public <R> CList<R> mapToList(Function<? super E, ? extends R> mapper) {
        return new CList((Iterable)this.map(mapper).collect(Collectors.toList()));
    }

    default public <R> CSet<R> mapToSet(Function<? super E, ? extends R> mapper) {
        return new CSet((Iterable)this.map(mapper).collect(Collectors.toList()));
    }

    @Override
    default public Spliterator<E> spliterator() {
        return ((Iterable)this.getBaseValue()).spliterator();
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Object[] toArray() {
        return this.stream().toArray();
    }

    default public <E1> E1[] toArray(E1[] a) {
        return this.toList().toArray((T[])a);
    }

    default public CList<E> toList() {
        return new CList((Iterable)this.getBaseValue());
    }

    default public CSet<E> toSet() {
        return new CSet((Iterable)this.getBaseValue());
    }
}

