/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.collections.interfaces;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.catools.common.collections.CHashMap;
import org.catools.common.collections.CLinkedMap;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.extensions.types.interfaces.CMapExtension;

public interface CMap<K, V>
extends Map<K, V>,
CMapExtension<K, V> {
    @Override
    default public CMap<K, V> getBaseValue() {
        return this;
    }

    default public CSet<Map.Entry<K, V>> asSet() {
        return new CSet(this.entrySet());
    }

    @Override
    default public CSet<K> keySet() {
        return new CSet(this.keySet());
    }

    @Override
    default public CList<V> values() {
        return new CList(this.values());
    }

    default public CHashMap<K, V> getAll(BiPredicate<K, V> predicate) {
        CHashMap result = new CHashMap();
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    default public CSet<K> getAllKeys(Predicate<V> predicate) {
        CSet result = new CSet();
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    default public CList<V> getAllValues(Predicate<K> predicate) {
        CList result = new CList();
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    default public Map.Entry<K, V> getFirst(BiPredicate<K, V> predicate) {
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            return entry;
        }
        throw new NoSuchElementException("No value present for provided predicate");
    }

    default public K getFirstKeyByValue(V value) {
        return this.getFirstKeyByValue(v -> Objects.equals(v, value));
    }

    default public K getFirstKeyByValue(Predicate<V> predicate) {
        K k = this.getFirstKeyByValueOrNull(predicate);
        if (k == null) {
            throw new NoSuchElementException("No key present for provided predicate");
        }
        return k;
    }

    default public K getFirstKeyByValueOrElse(V value, K otherKey) {
        return this.getFirstKeyByValueOrElse(v -> Objects.equals(v, value), otherKey);
    }

    default public K getFirstKeyByValueOrElse(Predicate<V> predicate, K otherKey) {
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getValue())) continue;
            return entry.getKey();
        }
        return otherKey;
    }

    default public K getFirstKeyByValueOrNull(V value) {
        return this.getFirstKeyByValueOrNull(v -> Objects.equals(v, value));
    }

    default public K getFirstKeyByValueOrNull(Predicate<V> predicate) {
        return this.getFirstKeyByValueOrElse(predicate, (K)null);
    }

    default public V getFirstValueByKey(K key) {
        return this.getFirstValueByKey(k -> Objects.equals(k, key));
    }

    default public V getFirstValueByKey(Predicate<K> predicate) {
        V v = this.getFirstValueByKeyOrNull(predicate);
        if (v == null) {
            throw new NoSuchElementException("No value present for provided predicate");
        }
        return v;
    }

    default public V getFirstValueByKeyOrElse(K key, V otherValue) {
        return this.getFirstValueByKeyOrElse(k -> Objects.equals(k, key), otherValue);
    }

    default public V getFirstValueByKeyOrElse(Predicate<K> predicate, V otherValue) {
        for (Map.Entry entry : this.asSet()) {
            if (!predicate.test(entry.getKey())) continue;
            return entry.getValue();
        }
        return otherValue;
    }

    default public V getFirstValueByKeyOrNull(K key) {
        return this.getFirstValueByKeyOrNull(k -> Objects.equals(k, key));
    }

    default public V getFirstValueByKeyOrNull(Predicate<K> predicate) {
        return this.getFirstValueByKeyOrElse(predicate, (V)null);
    }

    default public CLinkedMap<K, V> getSortedMap(Comparator<Map.Entry<K, V>> comparator) {
        LinkedList list = new LinkedList();
        this.asSet().forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)v -> list.add(v)));
        Collections.sort(list, comparator);
        CLinkedMap output = new CLinkedMap();
        for (Map.Entry entry : list) {
            output.put(entry.getKey(), entry.getValue());
        }
        return output;
    }
}

