/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.catools.common.collections.CList;
import org.catools.common.concurrent.exceptions.CInterruptedException;

public class CExecutorService<T> {
    private final AtomicReference<Throwable> throwableReference = new AtomicReference();
    private final List<Callable<T>> queue = Collections.synchronizedList(new CList());
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean finished = new AtomicBoolean();
    private final ExecutorService executor;
    private final String name;
    private final Long timeout;
    private final TimeUnit unit;
    private final boolean stopOnException;

    public CExecutorService(String name, int threadCount) {
        this(name, threadCount, null, null, true);
    }

    public CExecutorService(String name, int threadCount, boolean stopOnException) {
        this(name, threadCount, null, null, stopOnException);
    }

    public CExecutorService(String name, int threadCount, Long timeout, TimeUnit unit) {
        this(name, threadCount, timeout, unit, true);
    }

    public CExecutorService(String name, int threadCount, Long timeout, TimeUnit unit, boolean stopOnException) {
        this.executor = Executors.newFixedThreadPool(threadCount);
        this.name = name;
        this.timeout = timeout;
        this.unit = unit;
        this.stopOnException = stopOnException;
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isFinished() {
        return this.finished.get();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public void addCallable(Callable<T> callable) {
        this.queue.add(() -> {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                this.throwableReference.set(t);
                if (this.stopOnException) {
                    this.shutdownNow();
                }
                throw t;
            }
        });
    }

    public void invokeAll() throws Throwable {
        if (this.timeout != null && this.unit != null) {
            this.invokeAll(this.timeout, this.unit);
        } else {
            this.doInvoke(() -> {
                try {
                    this.executor.invokeAll(this.queue);
                }
                catch (InterruptedException e) {
                    throw new CInterruptedException("Parallel execution interrupted for " + this.name, e);
                }
                return true;
            });
        }
    }

    public void invokeAll(long timeout, TimeUnit unit) throws Throwable {
        this.doInvoke(() -> {
            try {
                this.executor.invokeAll(this.queue, timeout, unit);
            }
            catch (InterruptedException e) {
                throw new CInterruptedException("Parallel execution interrupted for " + this.name, e);
            }
            return true;
        });
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private void doInvoke(Supplier supplier) throws Throwable {
        this.started.set(true);
        supplier.get();
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
        this.finished.set(true);
        if (this.throwableReference.get() != null) {
            throw this.throwableReference.get();
        }
    }
}

