/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.catools.common.concurrent.CExecutorService;

public class CParallelRunner<T> {
    private final CExecutorService executor;

    public CParallelRunner(String name, int threadCount, Callable<T> callable) {
        this(name, threadCount, callable, true);
    }

    public CParallelRunner(String name, int threadCount, Callable<T> callable, boolean stopOnException) {
        this.executor = new CExecutorService(name, threadCount, stopOnException);
        for (int i = 0; i < threadCount; ++i) {
            this.executor.addCallable(callable);
        }
    }

    public boolean isStarted() {
        return this.executor.isStarted();
    }

    public boolean isFinished() {
        return this.executor.isFinished();
    }

    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    public void invokeAll() throws Throwable {
        this.executor.invokeAll();
    }

    public void invokeAll(long timeout, TimeUnit unit) throws Throwable {
        this.executor.invokeAll(timeout, unit);
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }
}

