/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.concurrent;

import java.util.Date;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.catools.common.collections.CList;
import org.catools.common.concurrent.CSleeper;
import org.catools.common.date.CDate;
import org.catools.common.exception.CStorageEmptyInitException;
import org.catools.common.logger.CLogger;
import org.catools.common.tests.CTest;

public class CStorage<T> {
    private final Object lock = new Object();
    private final CList<T> available = new CList();
    private final CList<T> borrowed = new CList();
    private final CLogger logger;
    private final int requestIntervalInSeconds;
    private final int requestTimeoutInSeconds;

    public CStorage(String name, int requestIntervalInSeconds, int requestTimeoutInSeconds) {
        this.logger = new CLogger("Storage " + name);
        this.requestIntervalInSeconds = requestIntervalInSeconds;
        this.requestTimeoutInSeconds = requestTimeoutInSeconds;
    }

    public void init(CList<T> initialObjects) {
        this.logger.info("Storage initiation...", new Object[0]);
        if (initialObjects.isEmpty()) {
            throw new CStorageEmptyInitException("Attempt to initiate storage with empty list.");
        }
        this.performActionOnQueue(() -> {
            this.available.addAll(initialObjects);
            return true;
        });
        this.logger.info("Storage initiated.", new Object[0]);
    }

    public <R> R performAction(CTest testInstance, Function<T, R> action) {
        return this.performAction(testInstance, t -> true, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R performAction(CTest testInstance, Predicate<T> predicate, Function<T, R> action) {
        T t = null;
        try {
            t = this.borrow(testInstance, predicate);
            R r = action.apply(t);
            return r;
        }
        finally {
            if (t != null) {
                this.release(t);
            }
        }
    }

    public T borrow(CTest testInstance) {
        return (T)this.borrow(testInstance, t -> true);
    }

    public T borrow(CTest testInstance, Predicate<T> predicate) {
        this.performActionOnQueue(() -> {
            this.logger.trace("Attempt to borrow object for " + testInstance.getName(), new Object[0]);
            this.logger.trace("Storage contains %s available and %s borrowed objects", this.available.size(), this.borrowed.size());
            return true;
        });
        Request<T> request = new Request<T>(testInstance, this.requestTimeoutInSeconds, predicate);
        return this.waitForObjectToBeAvailable(request);
    }

    public boolean release(T t) {
        if (t != null) {
            return this.performActionOnQueue(() -> {
                this.logger.trace("Object returned to storage. " + t.toString(), new Object[0]);
                this.borrowed.remove(t);
                this.available.add(t);
                this.logger.trace("Storage contains %s available and %s borrowed objects", this.available.size(), this.borrowed.size());
                return true;
            });
        }
        return false;
    }

    private T waitForObjectToBeAvailable(Request request) {
        Object response;
        while ((response = this.performActionOnQueue(() -> {
            Object firstOrElse;
            Object object = firstOrElse = this.available.isEmpty() ? null : this.available.getFirstOrElse(request.predicate, null);
            if (firstOrElse != null) {
                this.available.remove(firstOrElse);
                this.borrowed.add(firstOrElse);
                return firstOrElse;
            }
            if (request.isTimeOuted()) {
                throw new RuntimeException("Request Timeout triggered for TestCase:" + request.testInstance.getName());
            }
            return null;
        })) == null) {
            CSleeper.sleepTightInSeconds(this.requestIntervalInSeconds);
        }
        return (T)response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> T performActionOnQueue(Supplier<T> supplier) {
        Object object = this.lock;
        synchronized (object) {
            return supplier.get();
        }
    }

    static class Request<T> {
        private final Date timeoutAt;
        private final CTest testInstance;
        private final Predicate<T> predicate;

        public Request(CTest testInstance, int timeoutInSeconds, Predicate<T> predicate) {
            this.timeoutAt = CDate.now().addSeconds(timeoutInSeconds);
            this.predicate = predicate;
            this.testInstance = testInstance;
        }

        public boolean isTimeOuted() {
            return this.timeoutAt.before(new Date());
        }
    }
}

