/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.catools.common.concurrent.CThreadRunner;
import org.catools.common.concurrent.exceptions.CThreadTimeoutException;
import org.catools.common.date.CDate;

public class CTimeBoxRunner<R>
implements Runnable {
    private final Supplier<R> job;
    private final int timeoutInSeconds;
    private final boolean throwExceptionIfTimeout;
    private Throwable ex;
    private R r;

    private CTimeBoxRunner(Supplier<R> job, int timeoutInSeconds, boolean throwExceptionIfTimeout) {
        this.job = job;
        this.timeoutInSeconds = timeoutInSeconds;
        this.throwExceptionIfTimeout = throwExceptionIfTimeout;
    }

    public static <R> R get(Supplier<R> job, int timeoutInSeconds) {
        return CTimeBoxRunner.get(job, timeoutInSeconds, false);
    }

    public static <R> R get(Supplier<R> job, long timeout, TimeUnit unit, boolean throwExceptionIfTimeout) {
        return new CTimeBoxRunner<R>(job, (int)TimeUnit.SECONDS.convert(timeout, unit), throwExceptionIfTimeout).get();
    }

    public static <R> R get(Supplier<R> job, int timeoutInSeconds, boolean throwExceptionIfTimeout) {
        return new CTimeBoxRunner<R>(job, timeoutInSeconds, throwExceptionIfTimeout).get();
    }

    @Override
    public void run() {
        try {
            this.r = this.job.get();
        }
        catch (Throwable ex) {
            this.ex = ex;
        }
    }

    private R get() {
        Thread thread = CThreadRunner.run(this);
        CDate deadLine = new CDate().addSeconds(this.timeoutInSeconds);
        boolean timeoutFlag = false;
        while (this.r == null && thread.isAlive()) {
            if (!deadLine.before(new CDate())) continue;
            timeoutFlag = true;
            break;
        }
        if (thread.isAlive()) {
            thread.interrupt();
        }
        if (timeoutFlag && this.throwExceptionIfTimeout) {
            throw new CThreadTimeoutException("Job execution takes more time than expected");
        }
        if (this.ex != null) {
            throw new RuntimeException(this.ex);
        }
        return this.r;
    }
}

