/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.config;

import org.catools.common.collections.CList;
import org.catools.common.collections.interfaces.CMap;
import org.catools.common.config.CConfigInfo;
import org.catools.common.config.CConfigNotDefinedException;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CConsole;
import org.catools.common.text.CStringUtil;
import org.catools.common.utils.CArgsReader;

public class CCliConfigsLoader {
    public static void init(Class testClassLoader, boolean maskSensitiveInfo, String[] args) {
        CMap<String, String> stringStringCMap = CArgsReader.readArgs(args);
        System.setProperty("CONFIGS_TO_LOAD", (String)stringStringCMap.get("CONFIGS_TO_LOAD"));
        CCliConfigsLoader.loadArgsToConfigs(args);
        CConfigs.TestNG.setBaseTestClassLoader(testClassLoader.getName());
        CConfigs.Security.setMaskSensitiveInfo(maskSensitiveInfo);
        for (CConfigInfo property : CCliConfigsLoader.getRequiredToPromptProperties()) {
            property.setValue(CConsole.prompt(property.getDescription(), property.getDefaultValue(), property.isSensitive()));
        }
        CCliConfigsLoader.loadArgsToConfigs(args);
    }

    private static CList<CConfigInfo> getRequiredToPromptProperties() {
        return CConfigs.getConfigs().getAll(c -> c.isRequired() && !c.isDefined() && CStringUtil.isBlank((CharSequence)c.getValue()));
    }

    private static void loadArgsToConfigs(String[] args) {
        CArgsReader.readArgs(args).forEach((k, v) -> {
            try {
                CConfigs.getByName(k).setValue((String)v);
            }
            catch (CConfigNotDefinedException ex) {
                System.out.println("Could not find configuration " + k);
            }
        });
    }
}

