/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.catools.common.security.CSecurityManager;
import org.catools.common.text.CStringUtil;

public class CConfigInfo {
    private String name;
    private String value;
    private String description;
    private String defaultValue;
    private boolean required;
    private boolean sensitive;

    public CConfigInfo() {
    }

    public CConfigInfo(String name, String description, String defaultValue, boolean required, boolean sensitive) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.required = required;
        this.sensitive = sensitive;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public CConfigInfo setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public CConfigInfo setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CConfigInfo setName(String name) {
        this.name = name;
        return this;
    }

    @JsonIgnore
    public String getValue() {
        String val = (String)CStringUtil.defaultIfBlank((CharSequence)this.value, (CharSequence)System.getProperty(this.name));
        if (CStringUtil.isBlank((CharSequence)val)) {
            val = (String)CStringUtil.defaultIfBlank((CharSequence)System.getenv(this.name), (CharSequence)this.defaultValue);
        }
        if (this.isSensitive()) {
            CSecurityManager.addMask(val);
        }
        return val;
    }

    public CConfigInfo setValue(String value) {
        this.value = value;
        return this;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        result = 31 * result + (this.sensitive ? 1 : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @JsonIgnore
    public boolean isDefined() {
        return CStringUtil.isNotBlank((CharSequence)this.value);
    }

    public boolean isRequired() {
        return this.required;
    }

    public CConfigInfo setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public boolean isSensitive() {
        return this.sensitive;
    }

    public CConfigInfo setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
        return this;
    }

    public void merge(CConfigInfo c) {
        this.setName(c.getName()).setValue(c.value).setDefaultValue(c.getDefaultValue()).setDescription(c.getDescription()).setRequired(c.isRequired()).setSensitive(c.isSensitive());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CConfigInfo that = (CConfigInfo)o;
        if (this.required != that.required) {
            return false;
        }
        if (this.sensitive != that.sensitive) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public String toString() {
        return "CConfigInfo{name='" + this.name + "', descriptions='" + this.description + "', defaultValue='" + this.defaultValue + "', promptForValue=" + this.required + ", sensitive=" + this.sensitive + ", defindValue='" + this.value + "'}";
    }
}

