/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.config;

import java.util.stream.Stream;
import org.catools.common.collections.CList;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigInfo;
import org.catools.common.config.CConfigNotDefinedException;
import org.catools.common.io.CFile;
import org.catools.common.io.CResource;
import org.catools.common.io.CYamlUtil;
import org.catools.common.json.CJsonUtil;
import org.catools.common.security.CCipher;
import org.catools.common.text.CStringUtil;

public class CConfigInfoCollection
extends CSet<CConfigInfo> {
    public CConfigInfoCollection() {
    }

    public CConfigInfoCollection(CConfigInfo ... c) {
        super(c);
    }

    public CConfigInfoCollection(Stream<CConfigInfo> stream) {
        super(stream);
    }

    public CConfigInfoCollection(Iterable<CConfigInfo> iterable) {
        super(iterable);
    }

    public <T extends Enum<T>> CConfigInfo getByName(T config) {
        return this.getByName(config.name());
    }

    public CConfigInfo getByName(String configName) {
        return this.getFirstOrThrow(c -> CStringUtil.defaultString((String)c.getName()).equalsIgnoreCase(configName), new CConfigNotDefinedException(configName));
    }

    public <T extends Enum<T>> boolean getBoolean(T config) {
        return this.getBoolean(config.name());
    }

    public boolean getBoolean(String configName) {
        String prop = this.getString(configName);
        return !"".equals(prop) && Boolean.valueOf(prop) != false;
    }

    public <T extends Enum<T>> CList<Boolean> getBooleans(T config, String delimiter) {
        return this.getBooleans(config.name(), delimiter);
    }

    public CList<Boolean> getBooleans(String configName, String delimiter) {
        return this.getStrings(configName, delimiter).mapToList(s -> Boolean.valueOf(s));
    }

    public <T extends Enum<T>> double getDouble(T config) {
        return this.getDouble(config.name());
    }

    public double getDouble(String configName) {
        String prop = this.getString(configName);
        return "".equals(prop) ? 0.0 : Double.valueOf(prop);
    }

    public <T extends Enum<T>> int getInteger(T config) {
        return this.getInteger(config.name());
    }

    public int getInteger(String configName) {
        String prop = this.getString(configName);
        return "".equals(prop) ? 0 : Integer.valueOf(prop);
    }

    public <T extends Enum<T>> CList<Integer> getIntegers(T config, String delimiter) {
        return this.getIntegers(config.name(), delimiter);
    }

    public CList<Integer> getIntegers(String configName, String delimiter) {
        return this.getStrings(configName, delimiter).mapToList(s -> Integer.valueOf(s));
    }

    public <T extends Enum<T>> String getString(T config) {
        return this.getString(config.name());
    }

    public String getString(String configName) {
        return this.getByName(configName).getValue();
    }

    public <T extends Enum<T>> CList<String> getStrings(T config, String delimiter) {
        return this.getStrings(config.name(), delimiter);
    }

    public CList<String> getStrings(String configName, String delimiter) {
        String prop = this.getString(configName);
        return CStringUtil.isBlank((CharSequence)prop) ? new CList<String>() : new CList<String>(prop.split(delimiter));
    }

    public <T extends Enum<T>> boolean has(T config) {
        return this.has(config.name());
    }

    public boolean has(String configName) {
        return this.getFirstOrNull(c -> CStringUtil.defaultString((String)c.getName()).equalsIgnoreCase(configName)) != null;
    }

    public <T extends Enum<T>> boolean hasNot(T config) {
        return this.hasNot(config.name());
    }

    public boolean hasNot(String configName) {
        return !this.has(configName);
    }

    public CConfigInfoCollection merge(CConfigInfoCollection configInfo) {
        configInfo.forEach((? super E c) -> {
            if (this.has(c.getName())) {
                this.getByName(c.getName()).merge((CConfigInfo)c);
            } else {
                this.add(c);
            }
        });
        return this;
    }

    public CConfigInfoCollection mergeYamlFile(CFile file) {
        return this.merge(CYamlUtil.readFromFile(file, CConfigInfoCollection.class));
    }

    public CConfigInfoCollection mergeEncryptedYamlFile(CFile file, String secret) {
        return this.merge(CYamlUtil.readFromEncryptedFile(file, CConfigInfoCollection.class, secret));
    }

    public CConfigInfoCollection mergeYamlResource(String filename) {
        return this.merge(CYamlUtil.readFromResources(filename, CConfigInfoCollection.class));
    }

    public CConfigInfoCollection mergeYamlResource(CResource resource) {
        return this.merge(CYamlUtil.readFromResources(resource, CConfigInfoCollection.class));
    }

    public void saveToEncryptedFile(CFile file, String secret) {
        file.write(CCipher.encrypt(CJsonUtil.toString(this), secret));
    }

    public void saveToFile(CFile file) {
        CJsonUtil.write(file, this);
    }
}

