/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.catools.common.collections.CSet;
import org.catools.common.config.CConfigInfo;
import org.catools.common.config.CConfigInfoCollection;
import org.catools.common.config.CConfigsLoader;
import org.catools.common.date.CHoliday;
import org.catools.common.date.CHolidayCollection;
import org.catools.common.io.CFile;
import org.catools.common.io.CPlatform;
import org.catools.common.logger.CLogLevel;
import org.catools.common.testng.listeners.CExecutionResultListener;
import org.catools.common.testng.listeners.CExecutionStatisticListener;
import org.catools.common.testng.listeners.CExtentReportListener;
import org.catools.common.testng.listeners.CIMethodInterceptor;
import org.catools.common.text.CStringUtil;
import org.fusesource.jansi.Ansi;
import org.testng.ITestNGListener;
import org.testng.reporters.EmailableReporter2;
import org.testng.reporters.FailedReporter;
import org.testng.reporters.SuiteHTMLReporter;
import org.testng.reporters.TestHTMLReporter;

public class CConfigs {
    private static final CConfigInfoCollection CONFIGS = new CConfigInfoCollection();
    private static final AtomicInteger SUITE_RUN_COUNTER = new AtomicInteger(1);

    public static <T extends Enum<T>> CConfigInfo getByName(T config) {
        return CConfigs.getByName(config.name());
    }

    public static CConfigInfo getByName(String configName) {
        return CONFIGS.getByName(configName);
    }

    public static final CConfigInfoCollection getConfigs() {
        return CONFIGS;
    }

    static {
        CConfigsLoader.load();
    }

    public static class StringDiff {
        public static int getDiffEditCost() {
            return CONFIGS.getInteger(Configs.DIFF_TEXT_EDIT_COST);
        }

        public static Ansi.Color getInsertColor() {
            return Ansi.Color.valueOf((String)CONFIGS.getString(Configs.DIFF_TEXT_INSERT_COLOR));
        }

        public static Ansi.Color getDeleteColor() {
            return Ansi.Color.valueOf((String)CONFIGS.getString(Configs.DIFF_TEXT_DELETE_COLOR));
        }

        public static Ansi.Color getEqualColor() {
            return Ansi.Color.valueOf((String)CONFIGS.getString(Configs.DIFF_TEXT_EQUAL_COLOR));
        }

        public static String getInsertFormat() {
            return CONFIGS.getString(Configs.DIFF_TEXT_INSERT_FORMAT);
        }

        public static String getDeleteFormat() {
            return CONFIGS.getString(Configs.DIFF_TEXT_DELETE_FORMAT);
        }

        public static String getEqualFormat() {
            return CONFIGS.getString(Configs.DIFF_TEXT_EQUAL_FORMAT);
        }

        private static enum Configs {
            DIFF_TEXT_EDIT_COST,
            DIFF_TEXT_INSERT_FORMAT,
            DIFF_TEXT_DELETE_FORMAT,
            DIFF_TEXT_EQUAL_FORMAT,
            DIFF_TEXT_INSERT_COLOR,
            DIFF_TEXT_DELETE_COLOR,
            DIFF_TEXT_EQUAL_COLOR;

        }
    }

    public static class LoremIpsum {
        public static int getDefaultMaxParagraphLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MAX_PARAGRAPH_LENGTH);
        }

        public static int getDefaultMaxStatementLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MAX_STATEMENT_LENGTH);
        }

        public static int getDefaultMaxWordLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MAX_WORD_LENGTH);
        }

        public static int getDefaultMinParagraphLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MIN_PARAGRAPH_LENGTH);
        }

        public static int getDefaultMinStatementLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MIN_STATEMENT_LENGTH);
        }

        public static int getDefaultMinWordLength() {
            return CONFIGS.getInteger(Configs.LOREM_IPSUM_MIN_WORD_LENGTH);
        }

        private static enum Configs {
            LOREM_IPSUM_MIN_WORD_LENGTH,
            LOREM_IPSUM_MAX_WORD_LENGTH,
            LOREM_IPSUM_MIN_STATEMENT_LENGTH,
            LOREM_IPSUM_MAX_STATEMENT_LENGTH,
            LOREM_IPSUM_MIN_PARAGRAPH_LENGTH,
            LOREM_IPSUM_MAX_PARAGRAPH_LENGTH;

        }
    }

    public static class TypeExtension {
        public static int getDefaultWaitInSeconds() {
            return CONFIGS.getInteger(Configs.WAIT_EXTENSION_DEFAULT_WAIT_IN_SECONDS);
        }

        public static int getDefaultWaitIntervalInMilliSeconds() {
            return CONFIGS.getInteger(Configs.WAIT_EXTENSION_DEFAULT_WAIT_INTERVAL_IN_MILLIS);
        }

        private static enum Configs {
            WAIT_EXTENSION_DEFAULT_WAIT_INTERVAL_IN_MILLIS,
            WAIT_EXTENSION_DEFAULT_WAIT_IN_SECONDS;

        }
    }

    public static class ExtentReport {
        public static String getExtentReportFileName() {
            return CONFIGS.getString(Configs.EXTENT_REPORT_FILE_NAME);
        }

        public static String getExtentReportName() {
            return CONFIGS.getString(Configs.EXTENT_REPORT_NAME);
        }

        public static CSet<String> getExtentReportSystemInfo() {
            return CONFIGS.getStrings(Configs.EXTENT_REPORT_SYSTEM_INFO, ";").toSet();
        }

        public static boolean isEnable() {
            return CONFIGS.getBoolean(Configs.EXTENT_REPORT_ENABLE);
        }

        private static enum Configs {
            EXTENT_REPORT_ENABLE,
            EXTENT_REPORT_NAME,
            EXTENT_REPORT_FILE_NAME,
            EXTENT_REPORT_SYSTEM_INFO;

        }
    }

    public static class TestNG {
        public static Class getBaseClassLoader() {
            try {
                return Class.forName(CONFIGS.getString(Configs.TESTNG_BASE_TEST_CLASS_LOADER));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public static CSet<ITestNGListener> getListeners() {
            CSet<ITestNGListener> listeners = new CSet<ITestNGListener>();
            if (ExtentReport.isEnable()) {
                listeners.add((ITestNGListener)new CExtentReportListener());
            }
            listeners.add((ITestNGListener)new CExecutionResultListener());
            listeners.add((ITestNGListener)new CExecutionStatisticListener());
            listeners.add((ITestNGListener)new CIMethodInterceptor());
            listeners.add((ITestNGListener)new FailedReporter());
            listeners.add((ITestNGListener)new EmailableReporter2());
            listeners.add((ITestNGListener)new SuiteHTMLReporter());
            listeners.add((ITestNGListener)new TestHTMLReporter());
            for (String listener : CONFIGS.getStrings(Configs.TESTNG_LISTENERS, ",")) {
                try {
                    listeners.add((ITestNGListener)Class.forName(listener).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Throwable throwable) {}
            }
            return listeners;
        }

        public static int getSeverityLevel() {
            return CONFIGS.getInteger(Configs.TESTNG_RUN_SEVERITY_LEVEL);
        }

        public static int getRegressionDepth() {
            return CONFIGS.getInteger(Configs.TESTNG_RUN_REGRESSION_DEPTH);
        }

        public static int getTestRetryCount() {
            return CONFIGS.getInteger(Configs.TESTNG_TEST_RETRY_COUNT);
        }

        public static int getSuiteRetryCount() {
            return CONFIGS.getInteger(Configs.TESTNG_SUITE_RETRY_COUNT);
        }

        public static int getSuiteRunCounter() {
            return SUITE_RUN_COUNTER.get();
        }

        public static CSet<String> getTestPackages() {
            return new CSet<String>((Iterable<String>)CONFIGS.getStrings(Configs.TESTNG_TEST_PACKAGES, ","));
        }

        public static int getThreadCount() {
            return CONFIGS.getInteger(Configs.TESTNG_THREAD_COUNT);
        }

        public static Integer incrementSuiteRun() {
            return SUITE_RUN_COUNTER.incrementAndGet();
        }

        public static boolean isFirstSuiteRun() {
            return SUITE_RUN_COUNTER.get() == 1;
        }

        public static boolean isLastSuiteRun() {
            return SUITE_RUN_COUNTER.get() >= TestNG.getSuiteRetryCount() + 1;
        }

        public static void setBaseTestClassLoader(String className) {
            CONFIGS.getByName(Configs.TESTNG_BASE_TEST_CLASS_LOADER).setValue(className);
        }

        public static boolean skipClassWithAwaitingTest() {
            return CONFIGS.getBoolean(Configs.TESTNG_SKIP_CLASS_WITH_AWAITING_TEST);
        }

        public static boolean skipClassWithIgnoredTest() {
            return CONFIGS.getBoolean(Configs.TESTNG_SKIP_CLASS_WITH_IGNORED_TEST);
        }

        private static enum Configs {
            TESTNG_TEST_PACKAGES,
            TESTNG_THREAD_COUNT,
            TESTNG_LISTENERS,
            TESTNG_TEST_RETRY_COUNT,
            TESTNG_SUITE_RETRY_COUNT,
            TESTNG_BASE_TEST_CLASS_LOADER,
            TESTNG_SKIP_CLASS_WITH_AWAITING_TEST,
            TESTNG_SKIP_CLASS_WITH_IGNORED_TEST,
            TESTNG_RUN_SEVERITY_LEVEL,
            TESTNG_RUN_REGRESSION_DEPTH;

        }
    }

    public static class Date {
        private static final CHolidayCollection holidays = new CHolidayCollection();

        public static TimeZone getDefaultTimeZone() {
            return CStringUtil.isBlank((CharSequence)CONFIGS.getString(Configs.DATE_TIME_ZONE)) ? TimeZone.getDefault() : TimeZone.getTimeZone(CONFIGS.getString(Configs.DATE_TIME_ZONE));
        }

        public static CHolidayCollection getHolidays() {
            if (holidays.isEmpty()) {
                CONFIGS.getStrings(Configs.DATE_HOLIDAYS, ",").forEach(m -> holidays.add(new CHoliday((String)m)));
            }
            return holidays;
        }

        private static enum Configs {
            DATE_TIME_ZONE,
            DATE_HOLIDAYS;

        }
    }

    public static class Path {
        public static CFile getTmpResourcesFolder() {
            return Path.getTmpChildFolder("resources");
        }

        public static CFile getTmpDownloadFolder() {
            return Path.getTmpChildFolder("downloads");
        }

        public static CFile getTmpUploadFolder() {
            return Path.getTmpChildFolder("uploads");
        }

        public static CFile getLogFolder() {
            return Path.getOutputChildFolder("log");
        }

        public static CFile getLocalConfigFolder() {
            CFile properties = Path.getStorageChildFolder("configs");
            properties.mkdirs();
            return properties;
        }

        public static CFile getOutputFolder() {
            CFile cFile = new CFile(CONFIGS.getString(Configs.PATH_OUTPUT_DIRECTORY), Core.getRunName());
            cFile.mkdirs();
            return cFile;
        }

        public static String getOutputPath() {
            return Path.getOutputFolder().getCanonicalPath();
        }

        public static CFile getOutputRoot() {
            CFile output = new CFile(CONFIGS.getString(Configs.PATH_OUTPUT_DIRECTORY));
            output.forceMkdirs();
            return output;
        }

        public static CFile getStorageFolder() {
            CFile cFile = new CFile(CONFIGS.getString(Configs.PATH_STORAGE_DIRECTORY));
            cFile.mkdirs();
            return cFile;
        }

        public static CFile getTempFolder() {
            return Path.getOutputChildFolder("tmp");
        }

        public static CFile getOutputChildFolder(String childFolder) {
            CFile cFile = CFile.fromOutput(childFolder);
            cFile.mkdirs();
            return cFile;
        }

        public static CFile getTmpChildFolder(String childFolder) {
            CFile cFile = CFile.fromTmp(childFolder);
            cFile.mkdirs();
            return cFile;
        }

        public static CFile getStorageChildFolder(String childFolder) {
            CFile cFile = CFile.fromStorage(childFolder);
            cFile.mkdirs();
            return cFile;
        }

        public static CFile getImagesFolder() {
            return CFile.fromOutput("images");
        }

        public static CFile getActualImagesFolder() {
            return Path.getImagesFolder().getChildFolder("actual");
        }

        public static CFile getExpectedImagesFolder() {
            return Path.getImagesFolder().getChildFolder("expected");
        }

        public static CFile getDiffImagesFolder() {
            return Path.getImagesFolder().getChildFolder("diff");
        }

        private static enum Configs {
            PATH_STORAGE_DIRECTORY,
            PATH_OUTPUT_DIRECTORY;

        }
    }

    public static class Security {
        public static void setMaskSensitiveInfo(boolean flag) {
            CONFIGS.getByName(Configs.SECURITY_MASK_SENSITIVE_DATA).setValue("" + flag);
        }

        public static boolean shouldMaskSensitiveInfo() {
            return CONFIGS.getBoolean(Configs.SECURITY_MASK_SENSITIVE_DATA);
        }

        private static enum Configs {
            SECURITY_MASK_SENSITIVE_DATA;

        }
    }

    public static class Logger {
        public static boolean logColoredOutput() {
            return CONFIGS.getBoolean(Configs.LOGGER_LOG_COLORED);
        }

        public static boolean logStaticInfo() {
            return CONFIGS.getBoolean(Configs.LOGGER_LOG_STATIC_INFO);
        }

        public static CLogLevel getFileLogLevel() {
            return CLogLevel.valueOf(CONFIGS.getString(Configs.LOGGER_FILE_LOG_LEVEL));
        }

        public static CLogLevel getConsoleLogLevel() {
            return CLogLevel.valueOf(CONFIGS.getString(Configs.LOGGER_CONSOLE_LOG_LEVEL));
        }

        public static boolean logPassedVerification() {
            return CONFIGS.getBoolean(Configs.LOGGER_LOG_PASSED_VERIFICATION);
        }

        private static enum Configs {
            LOGGER_LOG_COLORED,
            LOGGER_LOG_STATIC_INFO,
            LOGGER_FILE_LOG_LEVEL,
            LOGGER_CONSOLE_LOG_LEVEL,
            LOGGER_LOG_PASSED_VERIFICATION;

        }
    }

    public static class DefectManagement {
        public static String getUrlToDefect() {
            return CONFIGS.getString(Configs.DMS_URL_FORMAT_TO_DEFECT);
        }

        public static String getUrlToDefect(String testKey) {
            String string = DefectManagement.getUrlToDefect();
            return CStringUtil.isBlank((CharSequence)string) ? "" : CStringUtil.format(string, testKey);
        }

        private static enum Configs {
            DMS_URL_FORMAT_TO_DEFECT;

        }
    }

    public static class TestManagement {
        public static String getProjectName() {
            return CONFIGS.getString(Configs.TMS_PROJECT_NAME);
        }

        public static String getVersionName() {
            return CONFIGS.getString(Configs.TMS_VERSION_NAME);
        }

        public static String getUrlToTest() {
            return CONFIGS.getString(Configs.TMS_URL_FORMAT_TO_TEST);
        }

        public static String getUrlToTest(String testKey) {
            String string = TestManagement.getUrlToTest();
            return CStringUtil.isBlank((CharSequence)string) ? "" : CStringUtil.format(string, testKey);
        }

        private static enum Configs {
            TMS_URL_FORMAT_TO_TEST,
            TMS_PROJECT_NAME,
            TMS_VERSION_NAME;

        }
    }

    public static class Core {
        public static String getRunName() {
            return TestNG.isLastSuiteRun() ? "" : "run_" + SUITE_RUN_COUNTER.get();
        }

        public static boolean isCleanupModeOn() {
            return CONFIGS.getBoolean(Configs.CORE_CLEANUP_MODE);
        }

        public static boolean isDataSetupModeOn() {
            return CONFIGS.getBoolean(Configs.CORE_DATA_SETUP_ENABLE);
        }

        public static boolean isLocalStorageEnable() {
            return CONFIGS.getBoolean(Configs.CORE_LOCAL_STORAGE_ENABLE);
        }

        public static boolean isProductionModeOn() {
            return CONFIGS.getBoolean(Configs.CORE_PRODUCTION_MODE);
        }

        public static boolean isReleaseModeOn() {
            return CONFIGS.getBoolean(Configs.CORE_RELEASE_MODE);
        }

        private static enum Configs {
            CORE_DATA_SETUP_ENABLE,
            CORE_CLEANUP_MODE,
            CORE_LOCAL_STORAGE_ENABLE,
            CORE_RELEASE_MODE,
            CORE_PRODUCTION_MODE;

        }
    }

    public static class System {
        private static String hostAddress;
        private static CPlatform platform;
        private static Boolean consoleIsAvailable;

        public static synchronized CPlatform getPlatform() {
            if (platform == null) {
                String operSys = java.lang.System.getProperty("os.name").toLowerCase();
                if (operSys.contains("win")) {
                    platform = CPlatform.WINDOWS;
                } else if (operSys.contains("nix") || operSys.contains("nux") || operSys.contains("aix")) {
                    platform = CPlatform.LINUX;
                } else if (operSys.contains("mac")) {
                    platform = CPlatform.MAC;
                }
            }
            return platform;
        }

        public static String getUserName() {
            return java.lang.System.getProperty("user.name");
        }

        public static synchronized String getHostIP() {
            try {
                if (CStringUtil.isBlank((CharSequence)hostAddress)) {
                    hostAddress = InetAddress.getLocalHost().getHostAddress();
                }
                return hostAddress;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }

        public static boolean isConsoleAvailable() {
            if (consoleIsAvailable == null) {
                consoleIsAvailable = java.lang.System.console() != null;
            }
            return consoleIsAvailable;
        }

        static {
            consoleIsAvailable = null;
        }
    }
}

