/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.config;

import java.io.File;
import org.catools.common.collections.CList;
import org.catools.common.config.CConfigInfo;
import org.catools.common.config.CConfigToLoadNotDefinedException;
import org.catools.common.config.CConfigs;
import org.catools.common.io.CConsole;
import org.catools.common.io.CFile;
import org.catools.common.io.CFileNotFoundException;
import org.catools.common.io.CResource;
import org.catools.common.text.CStringUtil;

public class CConfigsLoader {
    public static final CConfigInfo CONFIGS_TO_LOAD = new CConfigInfo("CONFIGS_TO_LOAD", "Yaml configuration file names to load before issue execution starts (comma separated).", null, true, false);

    public static void load() {
        if (CStringUtil.isBlank((CharSequence)CONFIGS_TO_LOAD.getValue())) {
            throw new CConfigToLoadNotDefinedException();
        }
        new CList<String>(CONFIGS_TO_LOAD.getValue().split(",")).forEach(config -> {
            if (CConfigsLoader.locateResource(config) != null) {
                CConfigsLoader.loadConfigResource(config);
            } else if (CConfigsLoader.locateFile(config) != null) {
                CConfigsLoader.loadConfigFile(config);
            } else {
                throw new CFileNotFoundException((String)config, "Cannot locate file in resource or local computer.");
            }
        });
        if (CStringUtil.isNotBlank((CharSequence)CConfigs.Path.getOutputPath())) {
            CConsole.println("cleanup %s", CConfigs.Path.getOutputRoot().getCanonicalPath());
            CConfigs.Path.getOutputRoot().delete();
        }
        CConfigs.getConfigs().add(CONFIGS_TO_LOAD);
    }

    private static void loadConfigFile(String config) {
        CList<CFile> files = new CList<CFile>();
        CFile cFile = CConfigsLoader.locateFile(config);
        if (cFile.isDirectory()) {
            for (File file : new CFile(config).listFiles()) {
                files.add(new CFile(file));
            }
        } else {
            files.add(new CFile(cFile));
        }
        CConfigsLoader.loadConfigFiles(files);
    }

    private static void loadConfigFiles(CList<CFile> files) {
        for (CFile s : files) {
            CConfigs.getConfigs().mergeYamlFile(CConfigsLoader.locateFile(s.getCanonicalPath()));
        }
    }

    private static void loadConfigResource(String config) {
        CConfigsLoader.loadConfigFiles(CConfigsLoader.locateResource(config).saveToFolder(new CFile(System.getProperty("java.io.tmpdir"))));
    }

    protected static CResource locateResource(String config) {
        CResource cResource = new CResource(config, CConfigsLoader.class);
        if (cResource.exists()) {
            return cResource;
        }
        return null;
    }

    protected static CFile locateFile(String config) {
        CFile configFile = new CFile(config);
        if (configFile.exists()) {
            return configFile;
        }
        try {
            configFile = CFile.fromStorage(config);
            if (configFile.exists()) {
                return configFile;
            }
        }
        catch (Throwable t) {
            return null;
        }
        configFile = CFile.fromOutput(config);
        if (configFile.exists()) {
            return configFile;
        }
        configFile = CFile.fromTmp(config);
        if (configFile.exists()) {
            return configFile;
        }
        return null;
    }
}

