/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.date;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.chrono.IsoEra;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.catools.common.config.CConfigs;
import org.catools.common.date.CInvalidDateFormatException;
import org.catools.common.extensions.types.interfaces.CDateExtension;
import org.catools.common.text.CStringUtil;

public class CDate
extends Date
implements CDateExtension {
    private static final String DATE_ONLY_FORMAT_STRING = "MM/dd/yyyy";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String LONG_DATE_FORMAT_STRING_MILI_SECONDS = "yyyy-MMM-dd HH:mm:ss:SSS";
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String SYS_DATE_FORMAT = "dd-MMM-yy";

    public CDate() {
    }

    public CDate(long date) {
        super(date);
    }

    public CDate(String date, String format) {
        if (CStringUtil.isNotBlank((CharSequence)date)) {
            CDate.valueOf(date, format);
        }
    }

    public CDate(Date date) {
        super(date.getTime());
    }

    public static CDate now() {
        return new CDate(Calendar.getInstance(CConfigs.Date.getDefaultTimeZone()).getTime());
    }

    public static CDate valueOf(String str, String ... parsePatterns) {
        try {
            return new CDate(DateUtils.parseDateStrictly((String)str, null, (String[])parsePatterns).getTime());
        }
        catch (Throwable t) {
            throw new CInvalidDateFormatException(String.format("cannot convert %s to date", str), t);
        }
    }

    public static CDate valueOf(String str, Locale locale, String ... parsePatterns) {
        try {
            return new CDate(DateUtils.parseDateStrictly((String)str, (Locale)locale, (String[])parsePatterns).getTime());
        }
        catch (Throwable t) {
            throw new CInvalidDateFormatException(String.format("cannot convert %s to date", str), t);
        }
    }

    public static CDate valueOfOrNull(String str, String ... parsePatterns) {
        try {
            return CDate.valueOf(str, parsePatterns);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static CDate valueOfOrNull(String str, Locale locale, String ... parsePatterns) {
        try {
            return CDate.valueOf(str, locale, parsePatterns);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String getFormattedDuration(Duration duration) {
        String time = String.format("%02d:%02d:%02d:%03d", duration.toHoursPart(), duration.toMinutesPart(), duration.toSecondsPart(), duration.toMillisPart()).replaceAll("\\s+", "0");
        if (duration.toDaysPart() > 0L) {
            return String.format("%dd %s", duration.toDaysPart(), time);
        }
        return time;
    }

    private static SimpleDateFormat getFormatter(String format) {
        return new SimpleDateFormat(format, Locale.US);
    }

    private static CDate toDate(String input, String format) {
        return CDate.valueOf(input, format);
    }

    public CDate addDays(int amount) {
        return this.add(5, amount);
    }

    public CDate addHours(int amount) {
        return this.add(11, amount);
    }

    public CDate addMilliseconds(int amount) {
        return this.add(14, amount);
    }

    public CDate addMinutes(int amount) {
        return this.add(12, amount);
    }

    public CDate addMonths(int amount) {
        return this.add(2, amount);
    }

    public CDate addSeconds(int amount) {
        return this.add(13, amount);
    }

    public CDate addWeeks(int amount) {
        return this.add(3, amount);
    }

    public CDate addYears(int amount) {
        return this.add(1, amount);
    }

    public LocalDate asLocalDate() {
        return this.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public CDate ceiling(int field) {
        this.setTime(DateUtils.ceiling((Date)this, (int)field).getTime());
        return this;
    }

    @Override
    public CDate clone() {
        return new CDate(this.getTime());
    }

    public int compareDateByFormat(Date date, String format) {
        if (date == null) {
            return 1;
        }
        new CDate(date);
        return CDate.toDate(this.toFormat(format), format).compareTo(CDate.toDate(new CDate(date).toFormat(format), format));
    }

    public int compareDatePortion(Date date) {
        return this.compareDateByFormat(date, DATE_ONLY_FORMAT_STRING);
    }

    public int compareTimePortion(Date date) {
        return this.compareDateByFormat(date, TIME_FORMAT);
    }

    public int get(int field) {
        return this.toCalendar().get(field);
    }

    public int getDayOfMonth() {
        return this.get(5);
    }

    public int getDayOfWeek() {
        return this.get(7);
    }

    public int getDayOfYear() {
        return this.get(6);
    }

    public Duration getDurationFrom(Date date) {
        return Duration.ofMillis(this.getTime() - date.getTime());
    }

    public Duration getDurationFromNow() {
        return this.getDurationFrom(CDate.now());
    }

    public Duration getDurationTo(Date date) {
        return Duration.ofMillis(date.getTime() - this.getTime());
    }

    public Duration getDurationToNow() {
        return this.getDurationTo(CDate.now());
    }

    public IsoEra getEra() {
        return this.toLocalTime().getEra();
    }

    public long getFragmentInDays(int fragment) {
        return DateUtils.getFragmentInDays((Date)this, (int)fragment);
    }

    public long getFragmentInHours(int fragment) {
        return DateUtils.getFragmentInHours((Date)this, (int)fragment);
    }

    public long getFragmentInMilliseconds(int fragment) {
        return DateUtils.getFragmentInMilliseconds((Date)this, (int)fragment);
    }

    public long getFragmentInMinutes(int fragment) {
        return DateUtils.getFragmentInMinutes((Date)this, (int)fragment);
    }

    public long getFragmentInSeconds(int fragment) {
        return DateUtils.getFragmentInSeconds((Date)this, (int)fragment);
    }

    public Month getMonthName() {
        return Month.of(this.get(2) + 1);
    }

    public Timestamp getTimeStamp() {
        return new Timestamp(this.getTime());
    }

    public boolean isLeapYear() {
        return this.toLocalTime().isLeapYear();
    }

    public boolean isSameDay(Date date) {
        return DateUtils.isSameDay((Date)this, (Date)date);
    }

    public boolean isSameInstant(Date date) {
        return DateUtils.isSameInstant((Date)this, (Date)date);
    }

    public boolean isSameLocalTime(Date date) {
        Calendar instance2 = Calendar.getInstance();
        instance2.setTime(date);
        return DateUtils.isSameLocalTime((Calendar)this.toCalendar(), (Calendar)instance2);
    }

    public boolean isTodayDate() {
        return this.compareDatePortion(new CDate()) == 0;
    }

    public boolean isMonday() {
        return this.getDayOfWeek() == 2;
    }

    public boolean isSaturday() {
        return this.getDayOfWeek() == 7;
    }

    public boolean isSunday() {
        return this.getDayOfWeek() == 1;
    }

    public boolean isThursday() {
        return this.getDayOfWeek() == 5;
    }

    public boolean isTuesday() {
        return this.getDayOfWeek() == 3;
    }

    public boolean isWednesday() {
        return this.getDayOfWeek() == 4;
    }

    public boolean isFriday() {
        return this.getDayOfWeek() == 6;
    }

    public int lengthOfMonth() {
        return this.toLocalTime().lengthOfMonth();
    }

    public int lengthOfYear() {
        return this.toLocalTime().lengthOfYear();
    }

    public CDate round(int field) {
        this.setTime(DateUtils.round((Date)this, (int)field).getTime());
        return this;
    }

    public CDate setDays(int amount) {
        return this.set(5, amount);
    }

    public CDate setMilliseconds(int amount) {
        return this.set(14, amount);
    }

    public CDate setMonths(int amount) {
        return this.set(2, amount);
    }

    public CDate setYears(int amount) {
        return this.set(1, amount);
    }

    public Calendar toCalendar() {
        return DateUtils.toCalendar((Date)this);
    }

    public Calendar toCalendar(TimeZone tz) {
        return DateUtils.toCalendar((Date)this, (TimeZone)tz);
    }

    public String toDateOnlyString() {
        return this.toFormat(DATE_ONLY_FORMAT_STRING);
    }

    public Duration toDuration() {
        return Duration.ofMillis(this.getTime());
    }

    public String toFormat(String format) {
        return CDate.getFormatter(format).format(this.getTime());
    }

    public String toFormat(String format, TimeZone timeZone) {
        SimpleDateFormat converter = CDate.getFormatter(format);
        converter.setTimeZone(timeZone);
        return converter.format(this);
    }

    public String toFormattedDuration() {
        return CDate.getFormattedDuration(this.toDuration());
    }

    public String toFormattedDurationFrom(Date date) {
        return CDate.getFormattedDuration(this.getDurationFrom(date));
    }

    public String toFormattedDurationFromNow() {
        return CDate.getFormattedDuration(this.getDurationFrom(CDate.now()));
    }

    public String toFormattedDurationTo(Date date) {
        return CDate.getFormattedDuration(this.getDurationTo(date));
    }

    public String toFormattedDurationToNow() {
        return CDate.getFormattedDuration(this.getDurationTo(CDate.now()));
    }

    public LocalDate toLocalTime() {
        return this.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public String toLongDate() {
        return this.toFormat(LONG_DATE_FORMAT_STRING_MILI_SECONDS);
    }

    public String toString(String format) {
        return this.toFormat(format);
    }

    @Override
    public String toString() {
        return this.toFormat(LONG_DATE_FORMAT_STRING_MILI_SECONDS);
    }

    public String toSysDate() {
        return this.toFormat(SYS_DATE_FORMAT);
    }

    public String toTimeStampForFileName() {
        return this.toFormat(TIMESTAMP_FORMAT).replaceAll("\\W+", "");
    }

    public CDate trimTime() {
        this.setTime(CDate.toDate(this.toFormat(DATE_ONLY_FORMAT_STRING), DATE_ONLY_FORMAT_STRING).getTime());
        return this;
    }

    public CDate truncate(int field) {
        this.setTime(DateUtils.truncate((Date)this, (int)field).getTime());
        return this;
    }

    public int truncatedCompareTo(Date date, int field) {
        return DateUtils.truncatedCompareTo((Date)this, (Date)date, (int)field);
    }

    public boolean truncatedEquals(Date date, int field) {
        return DateUtils.truncatedEquals((Date)this, (Date)date, (int)field);
    }

    private CDate add(int calendarField, int amount) {
        Calendar c = Calendar.getInstance();
        c.setTime(this);
        c.add(calendarField, amount);
        this.setTime(c.getTime().getTime());
        return this;
    }

    private CDate set(int calendarField, int amount) {
        Calendar c = this.toCalendar();
        c.setLenient(false);
        c.set(calendarField, amount);
        this.setTime(c.getTime().getTime());
        return this;
    }

    @Override
    public CDate getBaseValue() {
        return this;
    }
}

