/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.date;

import java.util.Calendar;
import java.util.Date;
import org.catools.common.date.CDate;
import org.catools.common.utils.CRandomUtil;

public class CDateRandomGenerator {
    private Calendar from = Calendar.getInstance();
    private Calendar to = Calendar.getInstance();

    private CDateRandomGenerator() {
    }

    public static CDateRandomGenerator instance() {
        return new CDateRandomGenerator();
    }

    public static CDateRandomGenerator instance(Calendar from, Calendar to) {
        return new CDateRandomGenerator().setFrom(from).setTo(to);
    }

    public static CDateRandomGenerator instance(Date from, Date to) {
        return new CDateRandomGenerator().setFrom(from).setTo(to);
    }

    public static CDateRandomGenerator instance(int fromYear, int toYear) {
        return new CDateRandomGenerator().setFromYear(fromYear).setToYear(toYear);
    }

    public static String getFormatedDate(Calendar from, Calendar to, String format) {
        return new CDateRandomGenerator().setFrom(from).setTo(to).getDate(format);
    }

    public static String getFormatedDate(Date from, Date to, String format) {
        return new CDateRandomGenerator().setFrom(from).setTo(to).getDate(format);
    }

    public static String getFormatedDate(int fromYear, int toYear, String format) {
        return new CDateRandomGenerator().setFromYear(fromYear).setToYear(toYear).getDate(format);
    }

    public CDateRandomGenerator setFrom(Calendar from) {
        this.from = from;
        return this;
    }

    public CDateRandomGenerator setFrom(Date from) {
        this.from.setTime(from);
        return this;
    }

    public CDateRandomGenerator setFromYear(int amount) {
        this.from.set(1, amount);
        return this;
    }

    public CDateRandomGenerator setFromMount(int amount) {
        this.from.set(2, amount);
        return this;
    }

    public CDateRandomGenerator setFromDayOfYear(int amount) {
        this.from.set(6, amount);
        return this;
    }

    public CDateRandomGenerator setFromDayOfMonth(int amount) {
        this.from.set(5, amount);
        return this;
    }

    public CDateRandomGenerator setFromHour(int amount) {
        this.from.set(10, amount);
        return this;
    }

    public CDateRandomGenerator setFromMinute(int amount) {
        this.from.set(12, amount);
        return this;
    }

    public CDateRandomGenerator setFromSecond(int amount) {
        this.from.set(13, amount);
        return this;
    }

    public CDateRandomGenerator setFromMilliSecond(int amount) {
        this.from.set(14, amount);
        return this;
    }

    public CDateRandomGenerator setTo(Calendar to) {
        this.to = to;
        return this;
    }

    public CDateRandomGenerator setTo(Date to) {
        this.to.setTime(to);
        return this;
    }

    public CDateRandomGenerator setToYear(int amount) {
        this.to.set(1, amount);
        return this;
    }

    public CDateRandomGenerator setToMount(int amount) {
        this.to.set(2, amount);
        return this;
    }

    public CDateRandomGenerator setToDayOfYear(int amount) {
        this.to.set(6, amount);
        return this;
    }

    public CDateRandomGenerator setToDayOfMonth(int amount) {
        this.to.set(5, amount);
        return this;
    }

    public CDateRandomGenerator setToHour(int amount) {
        this.to.set(10, amount);
        return this;
    }

    public CDateRandomGenerator setToMinute(int amount) {
        this.to.set(12, amount);
        return this;
    }

    public CDateRandomGenerator setToSecond(int amount) {
        this.to.set(13, amount);
        return this;
    }

    public CDateRandomGenerator setToMilliSecond(int amount) {
        this.to.set(14, amount);
        return this;
    }

    public CDate getDate() {
        return new CDate(CRandomUtil.Long.getNext(this.from.getTime().getTime(), this.to.getTime().getTime()));
    }

    public String getDate(String format) {
        return this.getDate().toFormat(format);
    }
}

