/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.date;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.catools.common.collections.CSet;
import org.catools.common.date.CDate;
import org.catools.common.date.CInvalidHolidayFormatException;

public class CHoliday {
    private Integer year;
    private Integer month;
    private Integer dayOfWeek;
    private Integer dayOfMonth;
    private Integer dayOfYear;
    private Integer weekOfMonth;
    private Integer weekOfYear;

    public CHoliday(String input) {
        new CSet<String>((Iterable<String>)Arrays.asList(input.strip().split("-"))).forEach(s -> {
            block9: {
                String strip = s.strip();
                try {
                    if (strip.startsWith("y")) {
                        this.year = Integer.valueOf(s.replace("y", ""));
                        break block9;
                    }
                    if (strip.startsWith("m")) {
                        this.month = Integer.valueOf(s.replace("m", ""));
                        break block9;
                    }
                    if (strip.startsWith("dm")) {
                        this.dayOfMonth = Integer.valueOf(s.replace("dm", ""));
                        break block9;
                    }
                    if (strip.startsWith("dw")) {
                        this.dayOfWeek = Integer.valueOf(s.replace("dw", ""));
                        break block9;
                    }
                    if (strip.startsWith("dy")) {
                        this.dayOfYear = Integer.valueOf(s.replace("dy", ""));
                        break block9;
                    }
                    if (strip.startsWith("wm")) {
                        this.weekOfMonth = Integer.valueOf(s.replace("wm", ""));
                        break block9;
                    }
                    if (strip.startsWith("wy")) {
                        this.weekOfYear = Integer.valueOf(s.replace("wy", ""));
                        break block9;
                    }
                    throw new CInvalidHolidayFormatException((String)s);
                }
                catch (Throwable t) {
                    throw new CInvalidHolidayFormatException((String)s);
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CHoliday cHoliday = (CHoliday)o;
        if (!Objects.equals(this.year, cHoliday.year)) {
            return false;
        }
        if (!Objects.equals(this.month, cHoliday.month)) {
            return false;
        }
        if (!Objects.equals(this.dayOfWeek, cHoliday.dayOfWeek)) {
            return false;
        }
        if (!Objects.equals(this.dayOfMonth, cHoliday.dayOfMonth)) {
            return false;
        }
        if (!Objects.equals(this.dayOfYear, cHoliday.dayOfYear)) {
            return false;
        }
        if (!Objects.equals(this.weekOfMonth, cHoliday.weekOfMonth)) {
            return false;
        }
        return Objects.equals(this.weekOfYear, cHoliday.weekOfYear);
    }

    public int hashCode() {
        int result = this.year != null ? this.year.hashCode() : 0;
        result = 31 * result + (this.month != null ? this.month.hashCode() : 0);
        result = 31 * result + (this.dayOfWeek != null ? this.dayOfWeek.hashCode() : 0);
        result = 31 * result + (this.dayOfMonth != null ? this.dayOfMonth.hashCode() : 0);
        result = 31 * result + (this.dayOfYear != null ? this.dayOfYear.hashCode() : 0);
        result = 31 * result + (this.weekOfMonth != null ? this.weekOfMonth.hashCode() : 0);
        result = 31 * result + (this.weekOfYear != null ? this.weekOfYear.hashCode() : 0);
        return result;
    }

    public boolean isHolidays(Date date) {
        CDate cDate = new CDate(date);
        if (this.year != null && cDate.get(1) != this.year.intValue()) {
            return false;
        }
        if (this.month != null && cDate.get(2) != this.month - 1) {
            return false;
        }
        if (this.dayOfMonth != null && cDate.get(5) != this.dayOfMonth.intValue()) {
            return false;
        }
        if (this.dayOfWeek != null && cDate.get(7) != this.dayOfWeek.intValue()) {
            return false;
        }
        if (this.dayOfYear != null && cDate.get(6) != this.dayOfYear.intValue()) {
            return false;
        }
        if (this.weekOfMonth != null && cDate.get(4) != this.weekOfMonth.intValue()) {
            return false;
        }
        return this.weekOfYear == null || cDate.get(3) == this.weekOfYear.intValue();
    }

    public String toString() {
        return "y" + this.year + "-m" + this.month + "-dw" + this.dayOfWeek + "-dm" + this.dayOfMonth + "-dy" + this.dayOfYear + "-wm" + this.weekOfMonth + "-wy" + this.weekOfYear;
    }
}

