/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.exception;

import java.util.Objects;
import org.catools.common.collections.CSet;
import org.catools.common.exception.CExceptionUtil;
import org.catools.common.text.CStringUtil;

public class CExceptionInfo {
    private String type = "";
    private String message = "";
    private String stackTrace = "";

    public CExceptionInfo() {
    }

    public CExceptionInfo(Throwable t) {
        if (t != null) {
            this.type = t.getClass().getName();
            this.message = t.getLocalizedMessage();
            this.stackTrace = CExceptionUtil.getStackTrace(t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CExceptionInfo that = (CExceptionInfo)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.stackTrace, that.stackTrace);
    }

    public String getAllInfo() {
        return new CSet<String>(this.type, this.message, this.stackTrace).getAll(s -> CStringUtil.isNotBlank((CharSequence)s)).join("\n");
    }

    public String getMessage() {
        return this.message;
    }

    public CExceptionInfo setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public CExceptionInfo setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CExceptionInfo setType(String type) {
        this.type = type;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message, this.stackTrace);
    }

    public String toString() {
        return "CExceptionInfo{type='" + this.type + "', message='" + this.message + "', stackTrace='" + this.stackTrace + "'}";
    }
}

