/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.executor;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.catools.common.concurrent.CSleeper;

public class CRetry {
    public static <R> R retryIf(Function<Integer, R> m, Predicate<R> retryIf, int retryCount, int interval) {
        return CRetry.retryIf(m, retryIf, retryCount, interval, null, true);
    }

    public static <R> R retryIf(Function<Integer, R> m, Predicate<R> retryIf, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIf(m, retryIf, retryCount, interval, orElse, true);
    }

    public static <R> R retryIf(Function<Integer, R> m, Predicate<R> retryIf, int retryCount, int interval, @Nullable Supplier<R> orElse, boolean throwLastException) {
        Throwable ex = null;
        int counter = 0;
        do {
            try {
                R r = m.apply(++counter);
                if (retryIf == null || !retryIf.test(r)) {
                    return r;
                }
            }
            catch (Throwable e) {
                ex = e;
            }
            CSleeper.sleepTight(interval);
        } while (retryCount-- > 0);
        if (throwLastException && ex != null) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return orElse == null ? null : (R)orElse.get();
    }

    public static <R> R retryIfNot(Function<Integer, R> m, Predicate<R> retryIfNot, int retryCount, int interval) {
        return CRetry.retryIfNot(m, retryIfNot, retryCount, interval, null, true);
    }

    public static <R> R retryIfNot(Function<Integer, R> m, Predicate<R> retryIfNot, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfNot(m, retryIfNot, retryCount, interval, orElse, true);
    }

    public static <R> R retryIfNot(Function<Integer, R> m, Predicate<R> retryIfNot, int retryCount, int interval, @Nullable Supplier<R> orElse, boolean throwLastException) {
        Throwable ex = null;
        int counter = 0;
        do {
            try {
                R r = m.apply(++counter);
                if (retryIfNot == null || retryIfNot.test(r)) {
                    return r;
                }
            }
            catch (Throwable e) {
                ex = e;
            }
            CSleeper.sleepTight(interval);
        } while (retryCount-- > 0);
        if (throwLastException && ex != null) {
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return orElse == null ? null : (R)orElse.get();
    }

    public static <R> R retryIfFalse(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfFalse(m, retryCount, interval, null, true);
    }

    public static <R> R retryIfFalse(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfFalse(m, retryCount, interval, orElse, true);
    }

    public static <R> R retryIfFalse(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t == null || t instanceof Boolean && (Boolean)t == false, retryCount, interval, orElse, throwLastException);
    }

    public static <R> R retryIfTrue(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfTrue(m, retryCount, interval, null, true);
    }

    public static <R> R retryIfTrue(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfTrue(m, retryCount, interval, orElse, true);
    }

    public static <R> R retryIfTrue(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t instanceof Boolean && (Boolean)t != false, retryCount, interval, orElse, throwLastException);
    }

    public static <R extends Collection> R retryIfEmpty(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfEmpty(m, retryCount, interval, null, true);
    }

    public static <R extends Collection> R retryIfEmpty(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfEmpty(m, retryCount, interval, orElse, true);
    }

    public static <R extends Collection> R retryIfEmpty(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t == null || t.isEmpty(), retryCount, interval, orElse, throwLastException);
    }

    public static <R extends Collection> R retryIfNotEmpty(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfNotEmpty(m, retryCount, interval, null, true);
    }

    public static <R extends Collection> R retryIfNotEmpty(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfNotEmpty(m, retryCount, interval, orElse, true);
    }

    public static <R extends Collection> R retryIfNotEmpty(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t != null && !t.isEmpty(), retryCount, interval, orElse, throwLastException);
    }

    public static <R extends Collection> R retryIfNull(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfNull(m, retryCount, interval, null, true);
    }

    public static <R extends Collection> R retryIfNull(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfNull(m, retryCount, interval, orElse, true);
    }

    public static <R extends Collection> R retryIfNull(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t == null, retryCount, interval, orElse, throwLastException);
    }

    public static <R extends Collection> R retryIfNotNull(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIfNotNull(m, retryCount, interval, null, true);
    }

    public static <R extends Collection> R retryIfNotNull(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIfNotNull(m, retryCount, interval, orElse, true);
    }

    public static <R extends Collection> R retryIfNotNull(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return (R)CRetry.retryIf(m, t -> t != null, retryCount, interval, orElse, throwLastException);
    }

    public static <R> R retry(Function<Integer, R> m, int retryCount, int interval) {
        return CRetry.retryIf(m, null, retryCount, interval, null);
    }

    public static <R> R retry(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse) {
        return CRetry.retryIf(m, null, retryCount, interval, orElse);
    }

    public static <R> R retry(Function<Integer, R> m, int retryCount, int interval, Supplier<R> orElse, boolean throwLastException) {
        return CRetry.retryIf(m, null, retryCount, interval, orElse, throwLastException);
    }
}

