/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.states.interfaces;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.catools.common.extensions.states.interfaces.CObjectState;
import org.catools.common.utils.CIterableUtil;

public interface CIterableState<E>
extends CObjectState<Iterable<E>> {
    default public boolean has(Predicate<E> expected) {
        for (Object a : (Iterable)this.getBaseValue()) {
            if (!expected.test(a)) continue;
            return true;
        }
        return false;
    }

    default public boolean hasNot(Predicate<E> expected) {
        for (Object a : (Iterable)this.getBaseValue()) {
            if (!expected.test(a)) continue;
            return false;
        }
        return true;
    }

    default public boolean isNotEmpty() {
        return CIterableUtil.isNotEmpty((Iterable)this.getBaseValue());
    }

    default public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    default public boolean contains(Object o) {
        for (Object a : (Iterable)this.getBaseValue()) {
            if (!Objects.equals(a, o)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(Iterable<E> expected, Consumer<E> onNotMatch) {
        if (expected == null) {
            return false;
        }
        Iterable actual = (Iterable)this.getBaseValue();
        boolean result = true;
        for (E t : expected) {
            if (CIterableUtil.contains(actual, t)) continue;
            if (onNotMatch == null) {
                return false;
            }
            result = false;
            onNotMatch.accept(t);
        }
        return result;
    }

    default public boolean containsNone(Iterable<E> expected) {
        return this.containsNone(expected, null);
    }

    default public boolean containsNone(Iterable<E> expected, Consumer<E> onMatch) {
        if (expected == null) {
            return false;
        }
        if (CIterableUtil.isEmpty(expected)) {
            return false;
        }
        Iterable actual = (Iterable)this.getBaseValue();
        boolean result = true;
        for (E t : expected) {
            if (!CIterableUtil.contains(actual, t)) continue;
            if (onMatch == null) {
                return false;
            }
            result = false;
            onMatch.accept(t);
        }
        return result;
    }

    default public boolean emptyOrContains(E expected) {
        if (expected == null) {
            return false;
        }
        Iterable a = (Iterable)this.getBaseValue();
        return a == null || CIterableUtil.isEmpty(a) || CIterableUtil.contains(a, expected);
    }

    default public boolean emptyOrNotContains(E expected) {
        if (expected == null) {
            return false;
        }
        Iterable a = (Iterable)this.getBaseValue();
        return a == null || CIterableUtil.isEmpty(a) || !CIterableUtil.contains(a, expected);
    }

    @Override
    default public boolean isEqual(Iterable<E> expected) {
        return this.isEqual(expected, null, null);
    }

    default public boolean isEqual(Iterable<E> expected, Consumer<E> onActualNotContains, Consumer<E> onExpectedNotContains) {
        if (expected == null) {
            return false;
        }
        Iterable actual = (Iterable)this.getBaseValue();
        boolean result = true;
        int actualSize = 0;
        int expectedSize = 0;
        for (Object t : expected) {
            ++expectedSize;
            if (CIterableUtil.contains(actual, t)) continue;
            if (onActualNotContains == null) {
                return false;
            }
            result = false;
            onActualNotContains.accept(t);
        }
        for (Object t : actual) {
            ++actualSize;
            if (CIterableUtil.contains(expected, t)) continue;
            if (onExpectedNotContains == null) {
                return false;
            }
            result = false;
            onExpectedNotContains.accept(t);
        }
        return expectedSize == actualSize && result;
    }

    default public boolean notContains(E expected) {
        if (expected == null) {
            return false;
        }
        return !CIterableUtil.contains((Iterable)this.getBaseValue(), expected);
    }

    default public boolean notContainsAll(Iterable<E> expected) {
        return this.notContainsAll(expected, null);
    }

    default public boolean notContainsAll(Iterable<E> expected, Consumer<E> onActualContains) {
        if (expected == null) {
            return false;
        }
        boolean contains = false;
        Iterable actual = (Iterable)this.getBaseValue();
        for (E t : expected) {
            if (CIterableUtil.contains(actual, t)) continue;
            if (onActualContains == null) {
                return true;
            }
            contains = false;
        }
        return contains;
    }
}

