/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.states.interfaces;

import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.catools.common.extensions.states.interfaces.CObjectState;

public interface CMapState<K, V>
extends CObjectState<Map<K, V>> {
    default public boolean contains(K expectedKey, V expectedValue) {
        return this.contains(Map.entry(expectedKey, expectedValue));
    }

    default public boolean contains(Map.Entry<K, V> expected) {
        if (expected == null) {
            return false;
        }
        Map a = (Map)this.getBaseValue();
        return a.containsKey(expected.getKey()) && Objects.equals(a.get(expected.getKey()), expected.getValue());
    }

    default public boolean containsAll(Map<K, V> expected) {
        return this.containsAll(expected, null);
    }

    default public boolean containsAll(Map<K, V> expected, Consumer<Map.Entry<K, V>> onNotMatch) {
        if (expected == null) {
            return false;
        }
        boolean result = true;
        Map a = (Map)this.getBaseValue();
        for (Map.Entry<K, V> t : expected.entrySet()) {
            if (a.containsKey(t.getKey()) && Objects.equals(a.get(t.getKey()), t.getValue())) continue;
            if (onNotMatch == null) {
                return false;
            }
            result = false;
            onNotMatch.accept(t);
        }
        return result;
    }

    default public boolean containsNone(Map<K, V> expected) {
        return this.containsNone(expected, null);
    }

    default public boolean containsNone(Map<K, V> expected, Consumer<Map.Entry<K, V>> onMatch) {
        if (expected == null) {
            return false;
        }
        boolean result = !expected.isEmpty();
        Map a = (Map)this.getBaseValue();
        for (Map.Entry<K, V> t : expected.entrySet()) {
            if (!a.containsKey(t.getKey()) || !Objects.equals(a.get(t.getKey()), t.getValue())) continue;
            if (onMatch == null) {
                return false;
            }
            result = false;
            onMatch.accept(t);
        }
        return result;
    }

    default public boolean emptyOrContains(K expectedKey, V expectedValue) {
        return this.emptyOrContains(Map.entry(expectedKey, expectedValue));
    }

    default public boolean emptyOrContains(Map.Entry<K, V> expected) {
        if (expected == null) {
            return false;
        }
        Map a = (Map)this.getBaseValue();
        if (a == null) {
            return true;
        }
        return a.isEmpty() || a.containsKey(expected.getKey()) && Objects.equals(a.get(expected.getKey()), expected.getValue());
    }

    default public boolean emptyOrNotContains(K expectedKey, V expectedValue) {
        return this.emptyOrNotContains(Map.entry(expectedKey, expectedValue));
    }

    default public boolean emptyOrNotContains(Map.Entry<K, V> expected) {
        if (expected == null) {
            return false;
        }
        Map a = (Map)this.getBaseValue();
        if (a == null) {
            return true;
        }
        return a.isEmpty() || !a.containsKey(expected.getKey()) || !Objects.equals(a.get(expected.getKey()), expected.getValue());
    }

    @Override
    default public boolean isEqual(Map<K, V> expected) {
        return Objects.equals(this.getBaseValue(), expected);
    }

    default public boolean isEqual(Map<K, V> expected, Consumer<Map.Entry<K, V>> onActualNotContains, Consumer<Map.Entry<K, V>> onExpectedNotContains) {
        if (expected == null) {
            return false;
        }
        Map actual = (Map)this.getBaseValue();
        boolean result = true;
        for (Map.Entry<K, V> t : expected.entrySet()) {
            if (actual.containsKey(t.getKey()) && Objects.equals(actual.get(t.getKey()), t.getValue())) continue;
            if (onActualNotContains == null) {
                return false;
            }
            result = false;
            onActualNotContains.accept(t);
        }
        for (Map.Entry<K, V> t : actual.entrySet()) {
            if (expected.containsKey(t.getKey()) && Objects.equals(expected.get(t.getKey()), t.getValue())) continue;
            if (onExpectedNotContains == null) {
                return false;
            }
            result = false;
            onExpectedNotContains.accept(t);
        }
        return expected.size() == actual.size() && result;
    }

    default public boolean isNotEmpty() {
        return this.getBaseValue() != null && !((Map)this.getBaseValue()).isEmpty();
    }

    default public boolean notContains(K expectedKey, V expectedValue) {
        return this.notContains(Map.entry(expectedKey, expectedValue));
    }

    default public boolean notContains(Map.Entry<K, V> expected) {
        if (expected == null) {
            return false;
        }
        Map a = (Map)this.getBaseValue();
        return !a.containsKey(expected.getKey()) || !Objects.equals(a.get(expected.getKey()), expected.getValue());
    }

    default public boolean notContainsAll(Map<K, V> expected) {
        if (expected == null) {
            return false;
        }
        boolean result = false;
        Map a = (Map)this.getBaseValue();
        for (Map.Entry<K, V> t : expected.entrySet()) {
            if (a.containsKey(t.getKey()) && Objects.equals(a.get(t.getKey()), t.getValue())) continue;
            return true;
        }
        return result;
    }

    default public boolean sizeEquals(int expected) {
        return this.getBaseValue() == null ? 0 == expected : ((Map)this.getBaseValue()).size() == expected;
    }

    default public boolean sizeIsGreaterThan(int expected) {
        return this.getBaseValue() == null ? 0 > expected : ((Map)this.getBaseValue()).size() > expected;
    }

    default public boolean sizeIsGreaterThanOrEqual(int expected) {
        return this.getBaseValue() == null ? 0 >= expected : ((Map)this.getBaseValue()).size() >= expected;
    }

    default public boolean sizeIsLessThan(int expected) {
        return this.getBaseValue() == null ? 0 < expected : ((Map)this.getBaseValue()).size() < expected;
    }

    default public boolean sizeIsLessThanOrEqual(int expected) {
        return this.getBaseValue() == null ? 0 <= expected : ((Map)this.getBaseValue()).size() <= expected;
    }
}

