/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.states.interfaces;

import java.util.Objects;
import org.catools.common.exception.CInvalidRangeException;
import org.catools.common.extensions.states.interfaces.CObjectState;

public interface CNumberState<N extends Number>
extends CObjectState<N> {
    default public boolean betweenExclusive(N lowerBound, N higherBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(higherBound);
        if (((Comparable)lowerBound).compareTo(higherBound) > 0) {
            throw new CInvalidRangeException("Lower Bound value should be less or equal to Higher Bound Value");
        }
        Number o = (Number)this.getBaseValue();
        return ((Comparable)((Object)o)).compareTo(higherBound) < 0 && ((Comparable)((Object)o)).compareTo(lowerBound) > 0;
    }

    default public boolean betweenInclusive(N lowerBound, N higherBound) {
        Objects.requireNonNull(lowerBound);
        Objects.requireNonNull(higherBound);
        if (((Comparable)lowerBound).compareTo(higherBound) > 0) {
            throw new CInvalidRangeException("Lower Bound value should be less or equal to Higher Bound Value");
        }
        Number o = (Number)this.getBaseValue();
        return ((Comparable)((Object)o)).compareTo(higherBound) <= 0 && ((Comparable)((Object)o)).compareTo(lowerBound) >= 0;
    }

    @Override
    default public boolean isEqual(N expected) {
        Number o = (Number)this.getBaseValue();
        return o == null || expected == null ? o == expected : ((Comparable)((Object)o)).compareTo(expected) == 0;
    }

    @Override
    default public boolean notEqual(N expected) {
        Number o = (Number)this.getBaseValue();
        return o == null || expected == null ? o != expected : ((Comparable)((Object)o)).compareTo(expected) != 0;
    }

    default public boolean isEqual(N expected, N precision) {
        Number o = (Number)this.getBaseValue();
        if (o == null || expected == null) {
            return o == expected;
        }
        if (o instanceof Integer) {
            return Math.abs(o.intValue() - ((Number)expected).intValue()) <= ((Number)precision).intValue();
        }
        if (o instanceof Long) {
            return Math.abs(o.longValue() - ((Number)expected).longValue()) <= ((Number)precision).longValue();
        }
        if (o instanceof Float) {
            return Math.abs(o.floatValue() - ((Number)expected).floatValue()) <= ((Number)precision).floatValue();
        }
        if (o instanceof Byte) {
            return Math.abs(o.byteValue() - ((Number)expected).byteValue()) <= ((Number)precision).byteValue();
        }
        if (o instanceof Short) {
            return Math.abs(o.shortValue() - ((Number)expected).shortValue()) <= ((Number)precision).shortValue();
        }
        return Math.abs(o.doubleValue() - ((Number)expected).doubleValue()) <= ((Number)precision).doubleValue();
    }

    default public boolean greater(N expected) {
        Objects.requireNonNull(expected);
        return ((Comparable)((Object)((Number)this.getBaseValue()))).compareTo(expected) > 0;
    }

    default public boolean greaterOrEqual(N expected) {
        Objects.requireNonNull(expected);
        return ((Comparable)((Object)((Number)this.getBaseValue()))).compareTo(expected) >= 0;
    }

    default public boolean less(N expected) {
        Objects.requireNonNull(expected);
        return ((Comparable)((Object)((Number)this.getBaseValue()))).compareTo(expected) < 0;
    }

    default public boolean lessOrEqual(N expected) {
        Objects.requireNonNull(expected);
        return ((Comparable)((Object)((Number)this.getBaseValue()))).compareTo(expected) <= 0;
    }

    default public boolean notBetweenExclusive(N lowerBound, N higherBound) {
        return !this.betweenExclusive(lowerBound, higherBound);
    }

    default public boolean notBetweenInclusive(N lowerBound, N higherBound) {
        return !this.betweenInclusive(lowerBound, higherBound);
    }

    default public boolean notEquals(N expected, N precision) {
        return !this.isEqual(expected, precision);
    }
}

