/*
 * Decompiled with CFR 0.152.
 */
package org.catools.common.extensions.states.interfaces;

import java.util.function.Predicate;
import org.catools.common.collections.CList;
import org.catools.common.extensions.states.interfaces.CBaseState;
import org.catools.common.utils.CIterableUtil;

public interface CObjectState<O>
extends CBaseState<O> {
    default public boolean test(Predicate<O> predicate) {
        return predicate.test(this.getBaseValue());
    }

    public boolean isEqual(O var1);

    default public boolean notEqual(O expected) {
        return !this.isEqual(expected);
    }

    default public boolean equalsAny(O ... expected) {
        if (expected == null) {
            return false;
        }
        return this.equalsAny((Iterable<O>)new CList<O>(expected));
    }

    default public boolean equalsAny(Iterable<O> expected) {
        if (expected == null) {
            return false;
        }
        for (O o : expected) {
            if (!this.isEqual(o)) continue;
            return true;
        }
        return false;
    }

    default public boolean equalsNone(O ... expected) {
        if (expected == null) {
            return false;
        }
        return this.equalsNone((Iterable<O>)new CList<O>(expected));
    }

    default public boolean equalsNone(Iterable<O> expected) {
        if (expected == null) {
            return false;
        }
        for (O o : expected) {
            if (!this.isEqual(o)) continue;
            return false;
        }
        return CIterableUtil.isNotEmpty(expected);
    }
}

